/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.test.ui.TestUI;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.internal.util.ContextIds;
import org.eclipse.hyades.ui.internal.report.ReportDescription;
import org.eclipse.hyades.ui.internal.report.ReportManager;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.report.IReportDescription;
import org.eclipse.hyades.ui.report.IReportGenerator;

class ReportWizardPage 
extends WizardPage implements Listener
{
	private IReportGenerator  reportGenerator;
	private IStructuredSelection selection;
	
	private Table  reportTable;
	private Button openEditorCheckBox;
	
	/**
	 * Constructor for ReportWizardPage.
	 */
	public ReportWizardPage(String name, IStructuredSelection sel)
	{
		super(name);
		
		selection = sel;
		
		setTitle(TestUIPlugin.getString("WIZ_TST_REPP_PG_TTL")); //$NON-NLS-1$
		setDescription(TestUIPlugin.getString("wizard.Report.NoDataPoolDefinition.Page")); //$NON-NLS-1$
		setPageComplete(false);
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent)
	{
		IPreferenceStore store = TestUIPlugin.getInstance().getPreferenceStore();
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(layout);
		composite.setLayoutData(GridDataUtil.createFill());
				
		reportTable = new Table(composite, SWT.BORDER | SWT.H_SCROLL | SWT.SINGLE);
		reportTable.setLayoutData(GridDataUtil.createFill());
		
		openEditorCheckBox = new Button(composite, SWT.CHECK);
		openEditorCheckBox.setText(TestUIPlugin.getString("REPORT_OPEN_EDITOR")); //$NON-NLS-1$
		openEditorCheckBox.setSelection(store.getBoolean(TestUI.REPORT_OPEN_EDITOR));
		openEditorCheckBox.setSelection(true);

		populateReportsTable();	
		reportTable.addListener(SWT.Selection, this);
		if(reportTable.getItemCount() > 0)
		{
			String reportName = getDialogSettings().get(ReportWizard.SET_LAST_REPORT);
			if(reportName != null)
			{
				Item[] items = reportTable.getItems();
				for (int i = 0, maxi = items.length; i < maxi; i++)
				{
					if(reportName.equals(items[i].getText()))
					{
						reportTable.select(i);
						break;
					}
				}
			}
			if(reportTable.getSelectionIndex() < 0)
				reportTable.select(0);
				
			Event event = new Event();
			event.widget = reportTable;
			event.item = reportTable.getSelection()[0];
			event.type = SWT.Selection;
			handleEvent(event);
		}

		reportTable.setFocus();
		setControl(composite);
		
		WorkbenchHelp.setHelp(composite, TestUIPlugin.getID() + ContextIds.REPORT_WIZ_PAGE);										
		WorkbenchHelp.setHelp(openEditorCheckBox, TestUIPlugin.getID() + ContextIds.REPORT_WIZ_EDIT_PAGE);	
		WorkbenchHelp.setHelp(reportTable, TestUIPlugin.getID() + ContextIds.REPORT_WIZ_TABLE_PAGE);		
	}
	
	
	public IReportGenerator getReportGenerator()
	{
		return reportGenerator;
	}
	
	public boolean openEditor()
	{
		return openEditorCheckBox.getSelection();
	}

	/**
	 * @see Listener#handleEvent(Event)
	 */
	public void handleEvent(Event event)
	{
		setErrorMessage(null);
		switch(event.type)
		{
			case SWT.Selection:
				ReportDescription rep = getReportDescription();
				boolean selectionOk = (rep != null);
				
				if(selectionOk)
				{
					try
					{
						reportGenerator = rep.getReportGenerator();
					}
					catch(Exception e)
					{
						reportGenerator = null;
						TestUIPlugin.logError(e);
					}
					finally
					{
						if(reportGenerator == null)
						{
							setErrorMessage(TestUIPlugin.getString("NO_INSTANCE_ERROR_")); //$NON-NLS-1$
							selectionOk = false;
						}
					}
					
					setMessage(null);
				}
				else
					setMessage(TestUIPlugin.getString("NO_REPORT_SEL")); //$NON-NLS-1$
				
				setPageComplete(selectionOk);
				break;
		}
	}
	
	public static boolean isInternalWebBrowserAvailable()
	{
		IWorkbench workbench = PlatformUI.getWorkbench();
		IEditorDescriptor[] editors = workbench.getEditorRegistry().getEditors("foo.html"); //$NON-NLS-1$
		for(int i = 0; i < editors.length; i++)
		{
			if("com.ibm.etools.webbrowser".equals(editors[i].getId())) //$NON-NLS-1$
				return true;
		}
		
		return false;
	}
	
    protected ReportDescription getReportDescription()
    {
    	int idx = reportTable.getSelectionIndex();
    	if(idx == -1)
    	   return null;
    	   
    	Object obj = reportTable.getItem(idx).getData();
    	if(obj instanceof ReportDescription)
    	  return ((ReportDescription)obj);
    	  
    	return null;     
    	//return reportDescription;	
    }
    
	private void populateReportsTable() {
		reportTable.removeAll();
		
		ReportManager manager = TestUI.getReportManager();
		IReportDescription[] list = manager.getReportDescriptions();
		
		for (int idx = 0; idx < list.length; idx++) {
			ReportDescription data = (ReportDescription)list[idx];
			
			IReportGenerator gen = null;			
			try {
				gen = data.getReportGenerator();	
			}
			catch(Exception exc)
			{
			}
						
			if(gen != null && gen.isAvailable(selection))
			{
				TableItem item = new TableItem(reportTable, SWT.NONE);
				item.setText(data.getName());
				item.setData(data);
				item.setImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_REPORT));	
			}
		}
	}
    
}