/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;

/**
 * Wizard for Test Component
 * @author marcelop
 * @since 0.2.0
 */
public class TestComponentNewWizard
extends HyadesWizard
{
	private AttributeWizardPage attributeWizardPage;
	
	/**
	 * Constructor for TestComponentNewWizard
	 */
	public TestComponentNewWizard()
	{
		super();

		setWindowTitle(TestUIPlugin.getString("WIZ_TST_CMP_TTL")); //$NON-NLS-1$
	}

	/**
	 * Returns the "name and description page" used by this wizard.
	 * @return NameDescriptionWizardPage
	 */
	protected AttributeWizardPage getAttributeWizardPage()
	{
		return attributeWizardPage;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		attributeWizardPage = new AttributeWizardPage("nameDescription"); //$NON-NLS-1$
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		String label = ((IWorkbenchAdapter)testSuite.getAdapter(IWorkbenchAdapter.class)).getLabel(testSuite);

		getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_TST_CMP_GEN_PG_TTL")); //$NON-NLS-1$
		getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_TST_CMP_GEN_PG_ATT_DSC", label)); //$NON-NLS-1$
		addPage(getAttributeWizardPage());
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		TPFTestComponent testComponent = Common_TestprofileFactory.eINSTANCE.createTPFTestComponent();
		testComponent.setName(getAttributeWizardPage().getItemName());
		testComponent.setDescription(getAttributeWizardPage().getItemDescription());
		
		if(testComponent.getBehaviors().isEmpty())
		{
			TPFBehavior behavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
			testComponent.getBehaviors().add(behavior);
		} 
		
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		testSuite.getTestComponents().add(testComponent);
		
		return true;
	}
}
