/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.configurations;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.testprofile.TPFTest;

/**
 * This class provides a Facade for getting/setting properties specific to a Single-Test
 * Launch Configuration.
 * @author jcanches
 */
public class TestLaunchConfigurationFacade extends AbstractLaunchConfigurationFacade {
	
	public final static String LAUNCH_CONFIGURATION_TYPE =  "org.eclipse.hyades.test.ui.launch.basicTest"; //$NON-NLS-1$
	
	public static ILaunchConfigurationType getLaunchConfigurationType() {
		return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE);
	}
	
	private final static String PROPERTY_TEST = PROPERTY_PREFIX + ".test"; //$NON-NLS-1$
	
	/**
	 * Retrieves the Test property of a Hyades Launch Configuration. This property defines
	 * which Test will be run by the Launch Configuration.
	 * @deprecated
	 * @see TestLaunchConfigurationFacade#getTest(ILaunchConfiguration, ResourceSet)
	 */
	public static TPFTest getTest(ILaunchConfiguration configuration) throws CoreException {
		EObject eObject = resolveEMFReference(configuration, PROPERTY_TEST);
		if (eObject != null && eObject instanceof TPFTest) {
			return (TPFTest)eObject;
		}
		return null;
	}
	
	/**
	 * Retrieves the Test property of a Hyades Launch Configuration. This property defines
	 * which Test will be run by the Launch Configuration.
	 * @param resourceSet The Resource Set that should contain the returned object.
	 * @since 3.1
	 */
	public static TPFTest getTest(ILaunchConfiguration configuration, ResourceSet resourceSet) throws CoreException {
		EObject eObject = resolveEMFReference(configuration, PROPERTY_TEST, resourceSet);
		if (eObject != null && eObject instanceof TPFTest) {
			return (TPFTest)eObject;
		}
		return null;
	}
	
	/**
	 * Define the Test property of a Hyades Launch Configuration. This property defines
	 * which Test will be run by the Launch Configuration.
	 */	
	public static void setTest(ILaunchConfigurationWorkingCopy configuration, TPFTest test) {
		storeEMFReference(configuration, PROPERTY_TEST, test);
	}
	
}
