/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.launch.extensions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * This interface is to be implemented by plugins extending the org.eclipse.hyades.test.ui.runHandler
 * extension point.
 * @author jcanches
 */
public interface IRunHandler {
	
	/**
	 * Method invoked after the user has selected and launched a Launch Configuration, and before
	 * the Test Harness is executing the selected Launch Configuration.
	 * @param configuration The Launch Configuration that is to be run.
	 * @param mode The run mode (usually "debug", "run", or "profile")
	 * @param launch The ILaunch object that represents the instance of the Launch Configuration
	 * being executed.
	 * @param ResourceSet The ResourceSet that should be used for manipulating EMF objects
	 * with the Launch Configuration Facade methods.
	 * @param monitor A Progress Monitor.
	 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	void preRun(ILaunchConfiguration configuration, String mode, ILaunch launch, ResourceSet resourceSet, IProgressMonitor monitor);
	
	/**
	 * Method invoked after a Launch Configuration has been run. The ILaunch object is the same
	 * that was passed to the <code>preRun</code> method. 
	 * @param launch
	 */
	void postRun(ILaunch launch);
	
}
