/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIPlugin;

/**
 * @author jgout
 */
public abstract class CMNNamedElementProxyNode extends EObjectProxyNode {
	private String name;

	/** Constructor
	 * 
	 * @param eObject the EMF named object to convert, the first argument should be a descendant of CMNNamedElement.
	 * @param parent its parent node.
	 */
	public CMNNamedElementProxyNode(EObject eObject, Object parent) {
		super(eObject, parent);
		if(eObject instanceof CMNNamedElement) {
			this.name = ((CMNNamedElement)eObject).getName();
		} else {
			throw new IllegalArgumentException("CMNNamedElementProxyNode can only be built upon CMNNamedElement"); //$NON-NLS-1$
		}
	}

	/** Returns the name of the named element given in the constructor. This name is used as the text shown in the navigator.
	 *  @return the name of the proxy.
	 */
	public String getText() {
		return this.name;
	}
}
