/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.testprofile.TPFDeployment;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.ArtifactProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DatapoolProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.DeploymentProxyNode;
import org.eclipse.hyades.test.ui.internal.navigator.proxy.LocationProxyNode;

/** This singleton factory can be used to create default proxy from hyades elements such as datapool, test case or location objects.
 *  The accepted inputs are: <br>
 * <ul>
 * <li> TPFTestSuite </li>
 * <li> TPFTestCase </li>
 * <li> DPLDatapool </li>
 * <li> CFGArtifact </li>
 * <li> CFGLocation </li>
 * <li> TPFExecutionResult </li>
 * </ul>
 * @author jgout
 * @since 3.2
 */
public class DefaultHyadesProxyNodeFactory {

	private static DefaultHyadesProxyNodeFactory instance;
	
	public static DefaultHyadesProxyNodeFactory getInstance() {
		if(instance == null) {
			instance = new DefaultHyadesProxyNodeFactory();
		}
		return instance;
	}
	
	private DefaultHyadesProxyNodeFactory() {
	}
	
	/** Convert a given EMF object into a proxy node usuable in the test navigator.
	 * EMF object supported by this method are: <br>
	 * <ul>
	 * <li> TPFTestSuite </li>
	 * <li> TPFTestCase </li>
	 * <li> DPLDatapool </li>
	 * <li> CFGArtifact </li>
	 * <li> CFGLocation </li>
	 * <li> TPFExecutionResult </li>
	 * </ul>
	 * 
	 * @param eObject object to be converted
	 * @param parent the parent of the converted proxy node
	 * @return a proxy node associated to the given EMF object or <code>null</code> if it is not supported by default
	 */
	public IProxyNode create(EObject eObject, Object parent) {
		if (eObject instanceof TPFTestSuite) {
			return new DefaultTestSuiteProxyNode((TPFTestSuite) eObject, parent);
		} else if (eObject instanceof TPFTestCase) {
			return new DefaultTestCaseProxyNode((TPFTestCase) eObject, parent);
		} else if (eObject instanceof DPLDatapool) {
			return new DatapoolProxyNode((DPLDatapool) eObject, parent);
		} else if (eObject instanceof TPFDeployment) {
			return new DeploymentProxyNode((TPFDeployment) eObject, parent);
		} else if (eObject instanceof CFGArtifact) {
			return new ArtifactProxyNode((CFGArtifact) eObject, parent);
		} else if (eObject instanceof CFGLocation) {
			return new LocationProxyNode((CFGLocation) eObject, parent);
		} else if (eObject instanceof TPFExecutionResult) {
			return new DefaultExecutionResultProxyNode((TPFExecutionResult) eObject, parent);
		}
		return null;
	}
	
}
