/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.test.ui.internal.model.EMFUtil;

/** EMF object proxy element for the test navigator.
 * Subclasses should provide IProxyNode methods implementation.
 * EMF objects wrapped by subclasses will be stored in the test navigator resource set
 * @author jgout
 */
public abstract class EObjectProxyNode implements IProxyNode {
	private URI originatorURI;
	private Object parent;
	
	/**
	 *  Creates a proxy node from a emf object.
	 *  CAUTION: this object should be stored in a EMF resource in order to get its URI
	 * @param eObject the originator object of the proxy
	 * @param parent the parent of this node
	 */
	public EObjectProxyNode (EObject eObject, Object parent) {
		originatorURI = EcoreUtil.getURI(eObject);
		this.parent = parent;
	}
	
	/**
	 * Returns the EMF object that is the originator of this proxy
	 * @return originator EMF object
	 */
	public EObject getEObject() {
		return EMFUtil.getEObject(null, originatorURI, true);
	}
	
	public Object getParent() {
		return parent;
	}
	
	public URI getOriginatorURI() {
		return originatorURI;
	}
	
	/** Identifier for an EMF object is its URI fragment part. If there is no fragment identifier is empty, this means that the object is a root object.  
	 * 
	 */
	public String getIdentifier() {
		String fragment = originatorURI.fragment();
		if(fragment != null) {
			return fragment;
		} else {
			return ""; //$NON-NLS-1$
		}
	}

	/**
	 * Underlying resource of an EMF object is the file containing this object.
	 */
	public IFile getUnderlyingResource() {
		return EMFUtil.getWorkspaceFile(originatorURI);
	}

}
