/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.util;

import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.TestUIPlugin;

/**
 * @author marcelop
 * @since 0.3.0
 */
public class TestUIUtil
{
	/**
	 * Returns a unique name based on the specified base and list of CMNNamedElement.
	 * @param baseName
	 * @param namedElementList
	 * @return String
	 */
	public static String getUniqueName(String baseName, List namedElementList)
	{
		int id = namedElementList.size()+1;
		String[] args = new String[]{baseName, Integer.toString(id)};
		String name = TestUIPlugin.getString("NME_CONCAT", args);

		for (Iterator i = namedElementList.iterator(); i.hasNext();)
		{
			CMNNamedElement namedElement = (CMNNamedElement)i.next();
			if(name.equals(namedElement.getName()))
			{
				args[1] = Integer.toString(++id);
				name = TestUIPlugin.getString("NME_CONCAT", args);
				i = namedElementList.iterator();
			}
		}
		
		return name;
	}
	
	/**
	 * This method validates that an extension was added to the file name. If the file 
	 * fails either test for a valid extension, the correct extension is appended to 
	 * the file name.
	 * @param result The result returned from the dialog's file name control
	 * @param extension The extension to add to the file name 
	 * @return correct file name with extension
	 */
	public static String validateExtension(String result, String extension) {
		/*
		 * 1. Test if the string is missing a "."
		 * 2. Test if the string contains the correct extension
		 */
		if (result.lastIndexOf(".") == -1 || 
				!result.substring(result.lastIndexOf(".")+1, result.length()).equalsIgnoreCase(extension)) {
			return result + "." + extension;
		}

		return result;
	}
}
