/**********************************************************************
 * Copyright (c) 2003,2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.preferences;

import org.eclipse.hyades.log.ui.internal.util.LogUIConstants;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * The page for setting java plugin preferences.
 */
public class SymptomDBurlPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

	private SymptomDBurl _urlOptions;

	public SymptomDBurlPreferencePage() {
		super();
		setPreferenceStore(SDbPlugin.getDefault().getPreferenceStore());
	}
	protected Control createContents(Composite parent) {
		
		org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		SDbPlugin.getPluginId()+".sdbp0000");
		
		Composite composite = new Composite(parent, SWT.NONE);

		GridData data = GridUtil.createFill();
		data.heightHint = 100;
		composite.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.marginWidth = 10;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		composite.setLayout(layout);

		_urlOptions = new SymptomDBurl();
		_urlOptions.createControl(composite);

		initializeValues();

		return composite;
	}
	public void init(IWorkbench workbench) {
	}
	/**
	 * Initializes states of the controls using default values
	 * in the preference store.
	 */
	private void initializeDefaults() {
		IPreferenceStore store = getPreferenceStore();

		_urlOptions.initializeValues(
			store.getDefaultString(LogUIConstants.SYMPTOM_DB_URL_32));

	}
	/**
	 * Initializes states of the controls from the preference store.
	 */
	private void initializeValues() {
		IPreferenceStore store = getPreferenceStore();

		_urlOptions.initializeValues(store.getString(LogUIConstants.SYMPTOM_DB_URL_32));
	}
	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults() {
		super.performDefaults();
		initializeDefaults();
	}
	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		SDbPlugin.getDefault().savePreferences();
		return true;
	}
	/**
	 * Stores the values of the controls back to the preference store.
	 */
	private void storeValues() {
		_urlOptions.storeValues(getPreferenceStore());
	}
}
