/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import java.text.*;
import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.models.internal.sdb.*;

public class SymptomDBExportUtil
{
 
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL + "" + NL + "<!DOCTYPE symptomDatabase [" + NL + "" + NL + "<!ELEMENT symptomDatabase (runtime+)>" + NL + "" + NL + "<!ELEMENT runtime (symptom+ , solution+ , directive*)>" + NL + "<!ATTLIST runtime" + NL + "    id ID #REQUIRED" + NL + "    name CDATA #IMPLIED" + NL + "    symptomUrl CDATA #IMPLIED" + NL + "    localExternalFileLocation CDATA #IMPLIED>" + NL + "" + NL + "<!ELEMENT symptom (matchPattern+)>" + NL + "<!ATTLIST symptom" + NL + "    id ID #REQUIRED" + NL + "    description CDATA #IMPLIED" + NL + "    solutions IDREFS #REQUIRED>" + NL + "" + NL + "<!ELEMENT matchPattern EMPTY>" + NL + "<!ATTLIST matchPattern" + NL + "    name CDATA #IMPLIED" + NL + "    value CDATA #REQUIRED>" + NL + "" + NL + "<!ELEMENT solution EMPTY>" + NL + "<!ATTLIST solution" + NL + "    id ID #REQUIRED" + NL + "    description CDATA #IMPLIED" + NL + "    directives IDREFS #IMPLIED>" + NL + "" + NL + "<!ELEMENT directive EMPTY>" + NL + "<!ATTLIST directive" + NL + "    id ID #REQUIRED" + NL + "    description CDATA #IMPLIED" + NL + "    directiveString CDATA #REQUIRED>" + NL + "]>" + NL + "" + NL + "<!--  Created on " + new SimpleDateFormat("EEEE, MMMMM dd, yyyy 'at' h:mm:ss:SSSS a z").format(new Date()) + " -->" + NL + "" + NL + "<symptomDatabase>" + NL + "    <runtime id=\"Runtime_0\" name=\"";
  protected final String TEXT_2 = "\" symptomUrl=\"";
  protected final String TEXT_3 = "\" localExternalFileLocation=\"";
  protected final String TEXT_4 = "\">" + NL + "    " + NL + "        <!-- Symptoms: -->" + NL;
  protected final String TEXT_5 = "         " + NL + "        <symptom id=\"Symptom_";
  protected final String TEXT_6 = "\" description=\"";
  protected final String TEXT_7 = "\" ";
  protected final String TEXT_8 = "solutions=\"";
  protected final String TEXT_9 = "\"";
  protected final String TEXT_10 = ">";
  protected final String TEXT_11 = NL + "            <matchPattern name=\"";
  protected final String TEXT_12 = "\" value=\"";
  protected final String TEXT_13 = "\"/>";
  protected final String TEXT_14 = "               " + NL + "        </symptom>";
  protected final String TEXT_15 = NL + NL + "        <!-- Solutions: -->" + NL;
  protected final String TEXT_16 = "         " + NL + "        <solution id=\"Solution_";
  protected final String TEXT_17 = "\" description=\"";
  protected final String TEXT_18 = "\" ";
  protected final String TEXT_19 = "directives=\"";
  protected final String TEXT_20 = "\"";
  protected final String TEXT_21 = "/>";
  protected final String TEXT_22 = NL + "     " + NL + "        <!-- Directives: -->" + NL;
  protected final String TEXT_23 = NL + "        <directive id=\"Directive_";
  protected final String TEXT_24 = "\" description=\"";
  protected final String TEXT_25 = "\" directiveString=\"";
  protected final String TEXT_26 = "\"/>";
  protected final String TEXT_27 = NL + "    </runtime>" + NL + "</symptomDatabase>";

 	public String normalize(String string) {

		if (string == null)
			return "null";

		StringBuffer normalizedString = new StringBuffer();
		char character;

		//Check all characters 
		for (int counter = 0; counter < string.length(); counter++) {

			character = string.charAt(counter);

			if (character == '<')
				normalizedString.append("&lt;");

			else if (character == '>')
				normalizedString.append("&gt;");

			else if (character == '&')
				normalizedString.append("&amp;");

			else if (character == '"')
				normalizedString.append("&quot;");

			else if (character == '\'')
				normalizedString.append("&apos;");
				
			else if (character == '\r')	
				normalizedString.append("&#xD;");
				
			else if (character == '\n')
				normalizedString.append("&#xA;");
				
			else if (character == '\t')
				normalizedString.append("&#x9;");
				
			else
				normalizedString.append(character);
		}

		return (normalizedString.toString());
	}
 
  /**
   * Generate xml from the SDBRuntime object
   */
  public String generate(SDBRuntime root, IProgressMonitor monitor)
  {
    StringBuffer stringBuffer = new StringBuffer();
    stringBuffer.append(TEXT_1);
    stringBuffer.append(normalize(root.getName()));
    stringBuffer.append(TEXT_2);
    stringBuffer.append(normalize(root.getSymptomUrl()));
    stringBuffer.append(TEXT_3);
    stringBuffer.append(normalize(root.getLocalExternalFileLocation()));
    stringBuffer.append(TEXT_4);
       EList symptList = root.getSymptoms();
     EList solutionList = root.getSolutions();	 
	 EList directivesList = root.getDirectives();
	 
	 int units = symptList.size() + solutionList.size() + directivesList.size();
     int i =0;int j=0;int k=0;
     if(!symptList.isEmpty()){

       for(i=0;i<symptList.size();i++){
         
         SDBSymptom current = (SDBSymptom)symptList.get(i);
         EList solList = current.getSolutions();
         String solutions = "";
         
         if(!solList.isEmpty()){
         	for(j=0;j<solList.size()-1;j++){
         		k = solutionList.indexOf((SDBSolution)solList.get(j));
         		solutions = solutions + "Solution_"+k + " ";
         	}
         	k = solutionList.indexOf((SDBSolution)solList.get(j));
         	         	
         	solutions = solutions + "Solution_"+k;
         }
    stringBuffer.append(TEXT_5);
    stringBuffer.append(i);
    stringBuffer.append(TEXT_6);
    stringBuffer.append(normalize(current.getDescription()));
    stringBuffer.append(TEXT_7);
    if(!solutions.equals("")){
    stringBuffer.append(TEXT_8);
    stringBuffer.append(solutions);
    stringBuffer.append(TEXT_9);
    }
    stringBuffer.append(TEXT_10);
    
            
         EList patternList = current.getPatterns();
         
         if(!patternList.isEmpty()){
           for(j=0;j<patternList.size();j++){
         	 SDBMatchPattern pattern = (SDBMatchPattern)patternList.get(j);
    stringBuffer.append(TEXT_11);
    stringBuffer.append(normalize(pattern.getName()));
    stringBuffer.append(TEXT_12);
    stringBuffer.append(normalize(pattern.getValue()));
    stringBuffer.append(TEXT_13);
    
           }
         }
         monitor.worked(8000/units);
    stringBuffer.append(TEXT_14);
    
       }
     }
    stringBuffer.append(TEXT_15);
       if(!solutionList.isEmpty()){
       for(i=0;i<solutionList.size();i++){
         
         SDBSolution sol = (SDBSolution)solutionList.get(i);
         EList dirList = sol.getDirectives();
         String directives = "";
         k = 0;
         if(!dirList.isEmpty()){
         	for(j=0;j<dirList.size() - 1;j++){         		
         		k = directivesList.indexOf((SDBDirective)dirList.get(j));
         		directives = directives + "Directive_"+k + " ";

         	}
         	k = directivesList.indexOf((SDBDirective)dirList.get(j));         	
         	directives = directives + "Directive_"+k;	
         }
    stringBuffer.append(TEXT_16);
    stringBuffer.append(i);
    stringBuffer.append(TEXT_17);
    stringBuffer.append(normalize(sol.getDescription()));
    stringBuffer.append(TEXT_18);
    if(!directives.equals("")){
    stringBuffer.append(TEXT_19);
    stringBuffer.append(directives);
    stringBuffer.append(TEXT_20);
    }
    stringBuffer.append(TEXT_21);
    
         monitor.worked(8000/units);
       }
     }
    stringBuffer.append(TEXT_22);
       if(!directivesList.isEmpty()){
       for(i=0;i<directivesList.size();i++){         
        SDBDirective dir = (SDBDirective)directivesList.get(i);
    stringBuffer.append(TEXT_23);
    stringBuffer.append(i);
    stringBuffer.append(TEXT_24);
    stringBuffer.append(normalize(dir.getDescription()));
    stringBuffer.append(TEXT_25);
    stringBuffer.append(normalize(dir.getDirectiveString()));
    stringBuffer.append(TEXT_26);
    
         monitor.worked(8000/units);
       }
     }
    stringBuffer.append(TEXT_27);
    return stringBuffer.toString();
  }
}
