/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.interfaces;

import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;

/**
 * @author psun
 */
public interface IDatapoolPart {

	/**
	 * Marks the editor as dirty.
	 */
	public void markDirty();
	
	/**
	 * Returns whether the content of this part is read only.
	 * 
	 * @return boolean
	 */
	public boolean isReadOnly();

	/**
	 * Returns the clipboard associated with this part.
	 * 
	 * @return Clipboard
	 */
	public Clipboard getClipboard();

	/**
	 * Returns the action bar associated with this part.
	 * 
	 * @return IActionBars
	 */
	public IActionBars getActionBars();
	
	/**
	 * Notifes the part that an edit action has occured.
	 *
	 */
	public void notifyEdit();
	
}
