package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.util.Map;

import org.eclipse.swt.widgets.Event;

public interface IWidgetListener 
{

	/**
	 * Takes an action based on the event passed as a parameter
	 * 
	 * @param event - The event that has been selected
	 */
	public void takeAction (Event event);
	
	
	/**
	 * This method is called once to store a reference to all existing
	 * widgets.
	 *
	 * @param widgets - A map of all the existing widget
	 */
	public void storeWidgets (Map widgets);
}
