/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logs.correlators;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

/**
 * RecordList is a wrapper for an EList which containes records of a specific log.
 * Since the filtering and correlation schemas may be log type dependent, the logType
 * needs to be set to the name/type of the log.
 */
public class RecordList extends BasicEList {

    private String logType;

    public RecordList(EList list, String type){
    	
    	addAll(list);
    	logType = type;
    }
    
    public EList getList(){
    	
       return this;	
    }
    
    public String getLogType(){
    	
       return logType;	
    }


}
