/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.collection.correlation.exceptions;

/**
 * This exception will be thrown if a given buffer is not sufficiently long for the data to be written.
 * 
 * @author Qiyan Li
 */
public class InsufficientBufferLengthException extends Exception {
	protected int requiredLength; // the length which will prevent the same exception from occurring

    /**
     * Creates a new exception with the required length set.
     * 
     * @param requiredLength    the length which will prevent the same exception from occurring
     */
    public InsufficientBufferLengthException(int requiredLength) {
			this.requiredLength = requiredLength;
	}
	
    /**
     * Returns the required length.
     * 
     * @return  the required length.
     */
	public int getRequiredLength() {
		return requiredLength;
	}
}
