/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.common.datapool.test;


import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.eclipse.hyades.edit.datapool.IDatapoolFactory;
import org.eclipse.hyades.edit.datapool.IDatapoolListener;
import org.eclipse.hyades.models.common.datapool.impl.Common_DatapoolFactoryImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLDatapoolImpl;
import org.eclipse.hyades.models.common.datapool.impl.DPLLogImpl;

public class DatapoolAPITest extends TestCase {

	IDatapoolListener lis = null;
	IDatapoolFactory editFactory = null;
	org.eclipse.hyades.execution.runtime.datapool.IDatapoolFactory runtimeFactory = null;

	org.eclipse.hyades.edit.datapool.IDatapool edp = null;	
	org.eclipse.hyades.execution.runtime.datapool.IDatapool rdp = null;
	File testDpXmiFile, testDpResFile;
	
	public DatapoolAPITest(String name)
	{
		super(name);
	}

	public static Test suite()
	{
		TestSuite junitTestSuite = new TestSuite("Datapool API Test");
	
		junitTestSuite.addTest(new DatapoolAPITest("testDatapoolSetup"));
		junitTestSuite.addTest(new DatapoolAPITest("testIDatapoolFactoryEdit"));
		junitTestSuite.addTest(new DatapoolAPITest("testIDatapoolEdit"));
		junitTestSuite.addTest(new DatapoolAPITest("testIDatapoolEquivalenceClassEdit"));
		junitTestSuite.addTest(new DatapoolAPITest("testIDatapoolFactoryRuntime"));
		junitTestSuite.addTest(new DatapoolAPITest("testRuntimeAPIs"));
				
		return junitTestSuite;
	}

	public void setUp()
	{   
        //Prepare a listener
		lis = new org.eclipse.hyades.edit.datapool.IDatapoolListener()
		{
			public void variableAdded(org.eclipse.hyades.edit.datapool.IDatapool datapool, int variableIndex)
			{
				DPLLogImpl.log("***Listener: variableAdded: " + variableIndex);
			}
			public void variableRemoved(org.eclipse.hyades.edit.datapool.IDatapool datapool, int variableIndex)
			{
				DPLLogImpl.log("***Listener: variableRemoved: " + variableIndex);
			}
			public void variableMoved(org.eclipse.hyades.edit.datapool.IDatapool datapool, int beforeVariableIndex, int afterVariableIndex)
			{
				DPLLogImpl.log("***Listener: variableMoved: " + beforeVariableIndex + " " + afterVariableIndex);
			}
			public void variableChanged(org.eclipse.hyades.edit.datapool.IDatapool datapool, int variableIndex)
			{
				DPLLogImpl.log("***Listener: variableChanged: " + variableIndex);
			}
			public void variableChanged(org.eclipse.hyades.edit.datapool.IDatapool datapool, int variableIndex, String oldName)
			{
				DPLLogImpl.log("***Listener: variableChanged: " + variableIndex + " " + oldName);
			}
			public void recordAdded(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivClassIndex, int recordIndex)
			{
				DPLLogImpl.log("***Listener: recordAdded: " + equivClassIndex + " " + recordIndex);
			}
			public void recordRemoved(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivClassIndex, int recordIndex)
			{
				DPLLogImpl.log("***Listener: recordRemoved: " + equivClassIndex + " " + recordIndex);
			}
			public void recordMoved(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivClassIndex, int beforeRecordIndex, int afterRecordIndex)
			{
				DPLLogImpl.log("***Listener: recordMoved: " + equivClassIndex + " " + beforeRecordIndex + " " + afterRecordIndex);
			}
			public void recordChanged(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivClassIndex, int recordIndex)
			{
				DPLLogImpl.log("***Listener: recordMoved: " + equivClassIndex + " " + recordIndex);
			}
			public void cellChanged(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex)
			{
				DPLLogImpl.log("***Listener: cellChanged: " + equivalenceClassIndex + " " + recordIndex + " " + variableIndex);
			}
			public void equivalenceClassReordered(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivalenceClassIndex)
			{
				DPLLogImpl.log("***Listener: equivalenceClassReordered");
			}

			public void equivalenceClassAdded(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivalenceClassIndex)
			{
				DPLLogImpl.log("***Listener: equivalenceClassAdded: " + equivalenceClassIndex);
			}		
			public void equivalenceClassRemoved(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivalenceClassIndex)
			{
				DPLLogImpl.log("***Listener: equivalenceClassRemoved: " + equivalenceClassIndex);
			}	
			public void equivalenceClassMoved(org.eclipse.hyades.edit.datapool.IDatapool datapool, int beforeEquivalenceClassIndex, int afterEquivalenceClassIndex)
			{
				DPLLogImpl.log("***Listener: equivalenceClassMoved: " + beforeEquivalenceClassIndex  + " " + afterEquivalenceClassIndex);
			}
			public void equivalenceClassChanged(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivalenceClassIndex)
			{
				DPLLogImpl.log("***Listener: equivalenceClassChanged: " + equivalenceClassIndex);
			}

			public void equivalenceClassChanged(org.eclipse.hyades.edit.datapool.IDatapool datapool, int equivalenceClassIndex, String oldName)
			{
				DPLLogImpl.log("***Listener: equivalenceClassChanged: " + equivalenceClassIndex + " " + oldName);
			}
			
			public void save(org.eclipse.hyades.edit.datapool.IDatapool datapool)
			{
				DPLLogImpl.log("***Listener: datapoolSaved");
			}				
		};
		
		editFactory = new Common_DatapoolFactoryImpl();
		runtimeFactory = new Common_DatapoolFactoryImpl();

		try {
		   testDpXmiFile = File.createTempFile("testDatapool", ".xmi");
		   testDpXmiFile.deleteOnExit();
		   testDpResFile = File.createTempFile("testDatapool", ".datapool");
		   testDpResFile.deleteOnExit();
		}
		catch (Throwable t) {
			t.printStackTrace();
		}
		
	}
	
	public void tearDown()
	{ 
	}
	
	public void testDatapoolSetup()	
	{
		
		DPLLogImpl.log("\n########## Hello to Datapool Setup (edit) Test!");
		
		edp = (org.eclipse.hyades.edit.datapool.IDatapool)editFactory.constructDatapool();
		edp.setName("DP1");
		edp.addDatapoolListener(lis);	
		
		org.eclipse.hyades.edit.datapool.IDatapoolVariable evar1 = edp.constructVariable();
		evar1.setName("LoginId");
		edp.appendVariable(evar1);
		
		org.eclipse.hyades.edit.datapool.IDatapoolVariable evar2 = edp.constructVariable();
		evar2.setName("Password");
		edp.appendVariable(evar2);		
		
		org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass eec1 = 
		edp.constructEquivalenceClass();
		eec1.setName("EC1");
		edp.appendEquivalenceClass(eec1);
		
		org.eclipse.hyades.edit.datapool.IDatapoolRecord erec1 =
			
			eec1.constructRecord(
			new Object[] {
				"<Literal>myLoginId</Literal>",
				"<Literal>myPassword</Literal>"
			}
		);
		
		org.eclipse.hyades.edit.datapool.IDatapoolRecord erec2 = eec1.constructRecord(
			new Object[] {
				"<Literal>yourLoginId</Literal>",
				"<Literal>yourPassword</Literal>"
			}
		);
		
		org.eclipse.hyades.edit.datapool.IDatapoolRecord erec3 = eec1.constructRecord(
			new Object[] {
				"<Literal>hisLoginId</Literal>",
				"<Literal>hisPassword</Literal>"
			}
		);
		
		eec1.appendRecord(erec1);
		eec1.appendRecord(erec2);
		eec1.appendRecord(erec3);
			
        ((DPLDatapoolImpl)edp).logDatapoolAsStrings();        
        assertTrue(edp.getEquivalenceClassCount() == 1);
        assertTrue(edp.getEquivalenceClass(0).getRecordCount() == 3);
		
		rdp = (org.eclipse.hyades.execution.runtime.datapool.IDatapool)edp;
		
		DPLLogImpl.log("########## Bye from Datapool Setup (edit) Test!");
		
	}
	
	public void testIDatapoolFactoryEdit()
	{
		DPLLogImpl.log("\n########## Hello to IDatapoolFactory (edit) Test!");
		
		DPLLogImpl.setLoggingStatus(false);
		testDatapoolSetup();
		DPLLogImpl.setLoggingStatus(true);
		
		((DPLDatapoolImpl)edp).logDatapoolAsStrings();
		
		editFactory.saveAs(edp, testDpXmiFile);
		
		//compress .xmi file to .datapool file		
		try { 
			
			FileInputStream fis = new FileInputStream(testDpXmiFile);
			FileOutputStream fos = new FileOutputStream(testDpResFile);
			ZipOutputStream zos = new ZipOutputStream(fos);
			ZipEntry ze = new ZipEntry("ResourceContents");
			zos.putNextEntry(ze);			
			byte[] buf = new byte[10];
			int r;
			while ((r = fis.read(buf, 0, 10)) != -1)
			{
				zos.write(buf, 0, r);
			}
			zos.close();		
		}
		catch (Throwable t) {
			t.printStackTrace();
		}
			
		edp = editFactory.loadForEdit(testDpResFile, false);

		((DPLDatapoolImpl)edp).logDatapoolAsStrings();
		
		DPLLogImpl.log("########## bye from IDatapool (edit) Test!");
	}

	
	public void testIDatapoolEdit()
	{				
		DPLLogImpl.log("\n########## Hello to IDatapool (edit) Test!");
		
		DPLLogImpl.setLoggingStatus(false);
        testDatapoolSetup();
		DPLLogImpl.setLoggingStatus(true);
		
		((DPLDatapoolImpl)edp).logDatapoolAsStrings();
		
		org.eclipse.hyades.edit.datapool.IDatapoolVariable evar0 = edp.constructVariable();
		evar0.setName("MachineName");
		
		edp.appendVariable(evar0);

		//((DPLDatapoolImpl)edp).logDatapoolAsStrings();						
		assertTrue(edp.getVariableCount() == 3);
		assertTrue(edp.getVariable(2).getName().equals("MachineName"));
	
		edp.moveVariable(1,0);
		
		//((DPLDatapoolImpl)edp).logDatapoolAsStrings();		
		assertTrue(edp.getVariable(0).getName().equals("Password"));
		assertTrue(edp.getVariable(1).getName().equals("LoginId"));
						
		edp.removeVariable(2);
		
		//((DPLDatapoolImpl)edp).logDatapoolAsStrings();		
		assertTrue(edp.getVariableCount() == 2);
		
		edp.updateVariable(evar0, 0);
		
		((DPLDatapoolImpl)edp).logDatapoolAsStrings();
		assertTrue(edp.getVariable(0).getName().equals("MachineName"));
				
		DPLLogImpl.log("########## Bye from IDatapool (edit) Test!");
		
	}
	
	public void testIDatapoolEquivalenceClassEdit()
	{
		DPLLogImpl.log("\n########## Hello to IDatapoolEquivalenceClass (edit) Test!");
		
		DPLLogImpl.setLoggingStatus(false);
		testDatapoolSetup();
		DPLLogImpl.setLoggingStatus(true);

        //add another equivalence class
		org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass eec2 = 
		edp.constructEquivalenceClass();
		eec2.setName("EC2");
		edp.appendEquivalenceClass(eec2);
		
		org.eclipse.hyades.edit.datapool.IDatapoolRecord erec1 = eec2.constructRecord(
			new Object[] {
				"<ExcelData>LoginId1</ExcelData>",
				"<ExcelData>Password1</ExcelData>"
			}
		);
		
		org.eclipse.hyades.edit.datapool.IDatapoolRecord erec2 = eec2.constructRecord(
			new Object[] {
				"<Literal>LoginId2</Literal>",
				"<Literal>Password2</Literal>"
			}
		);
		
		org.eclipse.hyades.edit.datapool.IDatapoolRecord erec3 = eec2.constructRecord(
			new Object[] {
				"<Literal>LoginId3</Literal>",
				"<Literal>Password3</Literal>"
			}
		);
		
		eec2.appendRecord(erec1);
		eec2.appendRecord(erec2);
		eec2.appendRecord(erec3);
			
		((DPLDatapoolImpl)edp).logDatapoolAsStrings();  
		      
		assertTrue(edp.getEquivalenceClassCount() == 2);
		assertTrue(edp.getEquivalenceClass(1).getRecordCount() == 3);	

        //test the test Excel evaluator extension
		org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell rcell1 = 
					rdp.getEquivalenceClass(1).getRecord(0).getCell("LoginId");
															
		assertTrue(rcell1.getCellVariable().getName().equals("LoginId"));
		assertTrue(rcell1.getStringValue().equals("LoginId1 (Excel)"));
		
		
				
		//edp.moveEquivalenceClass(1,-1);
		edp.moveEquivalenceClass(0,1);
		
		//((DPLDatapoolImpl)edp).logDatapoolAsStrings();
		assertTrue(edp.getEquivalenceClass(0).getName().equals("EC2"));
		assertTrue(edp.getEquivalenceClass(1).getName().equals("EC1"));
		
		edp.removeEquivalenceClass(1);
		
		//((DPLDatapoolImpl)edp).logDatapoolAsStrings();
		assertTrue(edp.getEquivalenceClassCount() == 1);
		assertTrue(edp.getEquivalenceClass(0).getName().equals("EC2"));	
				
		((org.eclipse.hyades.edit.datapool.IDatapoolEquivalenceClass)(edp.getEquivalenceClass(0))).reorder(new int[]{1,0,2});
		
		//((DPLDatapoolImpl)edp).logDatapoolAsStrings();	
		assertTrue(edp.getEquivalenceClass(0).getRecord(0).getCell("LoginId").getStringValue().equals("LoginId2"));	
		
		DPLLogImpl.log("########## bye from IDatapoolEquivalenceClass (edit) Test!");
	}
		
		
    public void testIDatapoolFactoryRuntime()
    {
		DPLLogImpl.log("\n########## Hello to IDatapool (runtime) Test!");
		
		DPLLogImpl.setLoggingStatus(false);
        testIDatapoolFactoryEdit();
        DPLLogImpl.setLoggingStatus(true);
		
		//((DPLDatapoolImpl)rdp).logDatapoolAsStrings();
		
		rdp = runtimeFactory.load(testDpResFile, true);      
		rdp = runtimeFactory.load(testDpResFile, true); 
		rdp = runtimeFactory.load(testDpResFile, true);
		
		
		runtimeFactory.unload(rdp);
		runtimeFactory.unload(rdp);
		runtimeFactory.unload(rdp);
		
		rdp = runtimeFactory.load(testDpResFile, true);   
		       
		((DPLDatapoolImpl)rdp).logDatapoolAsStrings();

		org.eclipse.hyades.execution.runtime.datapool.IDatapoolIterator it =
			//new org.eclipse.hyades.models.common.datapool.impl.DatapoolIteratorImpl_Private();
			runtimeFactory.open(rdp, 
				//"org.eclipse.hyades.datapool.iterator.DatapoolIteratorSequentialPrivate");
		        "org.eclipse.hyades.datapool.iterator.DatapoolIteratorSequentialShared");
       
		it.dpInitialize(rdp, -1);
		
		DPLLogImpl.log("");
		while(!it.dpDone())
		{
			DPLLogImpl.log("Iterator: " + it.dpString("LoginId"));
			it.dpNext();
		}
		
		runtimeFactory.close(it);
		
		DPLLogImpl.log("########## Bye from IDatapool (runtime) Test!");
    }
    
    public void testRuntimeAPIs()
        
    {
		DPLLogImpl.log("\n########## Hello to Runtime APIs Test!");
		 
		DPLLogImpl.setLoggingStatus(false);
        testDatapoolSetup();
        DPLLogImpl.setLoggingStatus(true);
		   
		//org.eclipse.hyades.execution.runtime.datapool.IDatapoolEquivalenceClass rec1 = 
		//			rdp.getEquivalenceClass(0);	
					
		//org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord rrec1 = 
		//			rec1.getRecord(0);		
				      
		org.eclipse.hyades.execution.runtime.datapool.IDatapoolCell rcell1 = 
					rdp.getEquivalenceClass(0).getRecord(0).getCell("LoginId");
																
	    assertTrue(rcell1.getCellVariable().getName().equals("LoginId"));
        assertTrue(rcell1.getStringValue().equals("myLoginId"));
        
		int i = rdp.getVariableIndex("LoginId");
		   
		org.eclipse.hyades.execution.runtime.datapool.IDatapoolVariable rvar1=
			rdp.getVariable(i);
			
		assertTrue(i==0);
		assertTrue(rvar1.getName().equals("LoginId"));
		
		DPLLogImpl.log("########## Bye from Runtime APIs Test!");	
	
	}

}





