/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A property is an attribute that can be specified by a name value pair.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
public interface IProperty extends INamedElement {

	/**
	 * Gets the value of the property.
	 * 
	 * @return String
	 */	
	public String getValue();

	/**
	 * Sets the value of the property.
	 * 
	 * @param value
	 */	
	public void setValue(String value);	
}
