/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.hyades.models.common.common.CMNNamedElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Execution Result</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The ExecutionResult (renamed Trace concept from the Test Profile) represents a snapshot of the execution of a TestCase or TestSuite. It contains deployment information, the ordered set of log actions performed during the test case, and the final verdict.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getTestVersion <em>Test Version</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getVerdict <em>Verdict</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getDeployment <em>Deployment</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getExecutionHistory <em>Execution History</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getInvocationExecutionEvent <em>Invocation Execution Event</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getTest <em>Test</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult()
 * @model 
 * @generated
 */
public interface TPFExecutionResult extends CMNNamedElement{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String copyright = "";

    /**
     * Returns the value of the '<em><b>Test Version</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Test Version</em>' attribute.
     * @see #setTestVersion(String)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult_TestVersion()
     * @model 
     * @generated
     */
	String getTestVersion();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getTestVersion <em>Test Version</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Test Version</em>' attribute.
     * @see #getTestVersion()
     * @generated
     */
	void setTestVersion(String value);

    /**
     * Returns the value of the '<em><b>Verdict</b></em>' attribute.
     * The literals are from the enumeration {@link org.eclipse.hyades.models.common.testprofile.TPFVerdict}.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Verdict</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Verdict</em>' attribute.
     * @see org.eclipse.hyades.models.common.testprofile.TPFVerdict
     * @see #setVerdict(TPFVerdict)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult_Verdict()
     * @model 
     * @generated
     */
	TPFVerdict getVerdict();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getVerdict <em>Verdict</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Verdict</em>' attribute.
     * @see org.eclipse.hyades.models.common.testprofile.TPFVerdict
     * @see #getVerdict()
     * @generated
     */
	void setVerdict(TPFVerdict value);

    /**
     * Returns the value of the '<em><b>Type</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Type</em>' attribute.
     * @see #setType(String)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult_Type()
     * @model 
     * @generated
     */
	String getType();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getType <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Type</em>' attribute.
     * @see #getType()
     * @generated
     */
	void setType(String value);

    /**
     * Returns the value of the '<em><b>Deployment</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Deployment</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Deployment</em>' reference.
     * @see #setDeployment(TPFDeployment)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult_Deployment()
     * @model required="true"
     * @generated
     */
	TPFDeployment getDeployment();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getDeployment <em>Deployment</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Deployment</em>' reference.
     * @see #getDeployment()
     * @generated
     */
	void setDeployment(TPFDeployment value);

    /**
     * Returns the value of the '<em><b>Execution History</b></em>' containment reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory#getExecutionResult <em>Execution Result</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Execution History</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Execution History</em>' containment reference.
     * @see #setExecutionHistory(TPFExecutionHistory)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult_ExecutionHistory()
     * @see org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory#getExecutionResult
     * @model opposite="executionResult" containment="true" required="true"
     * @generated
     */
	TPFExecutionHistory getExecutionHistory();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getExecutionHistory <em>Execution History</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Execution History</em>' containment reference.
     * @see #getExecutionHistory()
     * @generated
     */
	void setExecutionHistory(TPFExecutionHistory value);

    /**
     * Returns the value of the '<em><b>Invocation Execution Event</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent#getInvokedExecutionResult <em>Invoked Execution Result</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Invocation Execution Event</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Invocation Execution Event</em>' container reference.
     * @see #setInvocationExecutionEvent(TPFInvocationEvent)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult_InvocationExecutionEvent()
     * @see org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent#getInvokedExecutionResult
     * @model opposite="invokedExecutionResult"
     * @generated
     */
	TPFInvocationEvent getInvocationExecutionEvent();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getInvocationExecutionEvent <em>Invocation Execution Event</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Invocation Execution Event</em>' container reference.
     * @see #getInvocationExecutionEvent()
     * @generated
     */
	void setInvocationExecutionEvent(TPFInvocationEvent value);

    /**
     * Returns the value of the '<em><b>Test</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Test</em>' reference.
     * @see #setTest(TPFTest)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFExecutionResult_Test()
     * @model required="true"
     * @generated
     */
	TPFTest getTest();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFExecutionResult#getTest <em>Test</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Test</em>' reference.
     * @see #getTest()
     * @generated
     */
	void setTest(TPFTest value);

} // TPFExecutionResult
