/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.configuration.impl.CFGClassImpl;
import org.eclipse.hyades.models.common.datapool.DPLDatapool;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFArbiter;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFSUT;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestComponent;
import org.eclipse.hyades.models.common.testprofile.TPFTestObjective;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Test Suite</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getTestObjectives <em>Test Objectives</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getBehavior <em>Behavior</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getPersistenceId <em>Persistence Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getTestCases <em>Test Cases</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getSUTs <em>SU Ts</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getArbiter <em>Arbiter</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getTestComponents <em>Test Components</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getReferencedSuites <em>Referenced Suites</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestSuiteImpl#getDatapools <em>Datapools</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFTestSuiteImpl extends CFGClassImpl implements TPFTestSuite
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected static final String TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected String type = TYPE_EDEFAULT;

    /**
     * The cached value of the '{@link #getTestObjectives() <em>Test Objectives</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTestObjectives()
     * @generated
     * @ordered
     */
	protected EList testObjectives = null;

    /**
     * The cached value of the '{@link #getBehavior() <em>Behavior</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getBehavior()
     * @generated
     * @ordered
     */
	protected TPFBehavior behavior = null;

    /**
     * The default value of the '{@link #getPersistenceId() <em>Persistence Id</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getPersistenceId()
     * @generated
     * @ordered
     */
	protected static final String PERSISTENCE_ID_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getPersistenceId() <em>Persistence Id</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getPersistenceId()
     * @generated
     * @ordered
     */
	protected String persistenceId = PERSISTENCE_ID_EDEFAULT;

    /**
     * The cached value of the '{@link #getTestCases() <em>Test Cases</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTestCases()
     * @generated
     * @ordered
     */
	protected EList testCases = null;

    /**
     * The cached value of the '{@link #getSUTs() <em>SU Ts</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getSUTs()
     * @generated
     * @ordered
     */
	protected EList suTs = null;

    /**
     * The cached value of the '{@link #getArbiter() <em>Arbiter</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getArbiter()
     * @generated
     * @ordered
     */
	protected TPFArbiter arbiter = null;

    /**
     * The cached value of the '{@link #getTestComponents() <em>Test Components</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTestComponents()
     * @generated
     * @ordered
     */
	protected EList testComponents = null;

    /**
     * The cached value of the '{@link #getReferencedSuites() <em>Referenced Suites</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getReferencedSuites()
     * @generated
     * @ordered
     */
	protected EList referencedSuites = null;

    /**
     * The cached value of the '{@link #getDatapools() <em>Datapools</em>}' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getDatapools()
     * @generated
     * @ordered
     */
	protected EList datapools = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TPFTestSuiteImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_TestprofilePackage.eINSTANCE.getTPFTestSuite();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getType()
    {
        return type;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setType(String newType)
    {
        String oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__TYPE, oldType, type));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getTestObjectives()
    {
        if (testObjectives == null)
        {
            testObjectives = new EObjectContainmentWithInverseEList(TPFTestObjective.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES, Common_TestprofilePackage.TPF_TEST_OBJECTIVE__TEST);
        }
        return testObjectives;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFBehavior getBehavior()
    {
        return behavior;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetBehavior(TPFBehavior newBehavior, NotificationChain msgs)
    {
        TPFBehavior oldBehavior = behavior;
        behavior = newBehavior;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR, oldBehavior, newBehavior);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setBehavior(TPFBehavior newBehavior)
    {
        if (newBehavior != behavior)
        {
            NotificationChain msgs = null;
            if (behavior != null)
                msgs = ((InternalEObject)behavior).eInverseRemove(this, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, TPFBehavior.class, msgs);
            if (newBehavior != null)
                msgs = ((InternalEObject)newBehavior).eInverseAdd(this, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, TPFBehavior.class, msgs);
            msgs = basicSetBehavior(newBehavior, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR, newBehavior, newBehavior));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getPersistenceId()
    {
        return persistenceId;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setPersistenceId(String newPersistenceId)
    {
        String oldPersistenceId = persistenceId;
        persistenceId = newPersistenceId;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID, oldPersistenceId, persistenceId));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getTestCases()
    {
        if (testCases == null)
        {
            testCases = new EObjectContainmentWithInverseEList(TPFTestCase.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES, Common_TestprofilePackage.TPF_TEST_CASE__TEST_SUITE);
        }
        return testCases;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getSUTs()
    {
        if (suTs == null)
        {
            suTs = new EObjectContainmentWithInverseEList(TPFSUT.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS, Common_TestprofilePackage.TPFSUT__TEST_SUITE);
        }
        return suTs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFArbiter getArbiter()
    {
        return arbiter;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetArbiter(TPFArbiter newArbiter, NotificationChain msgs)
    {
        TPFArbiter oldArbiter = arbiter;
        arbiter = newArbiter;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, oldArbiter, newArbiter);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setArbiter(TPFArbiter newArbiter)
    {
        if (newArbiter != arbiter)
        {
            NotificationChain msgs = null;
            if (arbiter != null)
                msgs = ((InternalEObject)arbiter).eInverseRemove(this, Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE, TPFArbiter.class, msgs);
            if (newArbiter != null)
                msgs = ((InternalEObject)newArbiter).eInverseAdd(this, Common_TestprofilePackage.TPF_ARBITER__TEST_SUITE, TPFArbiter.class, msgs);
            msgs = basicSetArbiter(newArbiter, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, newArbiter, newArbiter));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getTestComponents()
    {
        if (testComponents == null)
        {
            testComponents = new EObjectContainmentWithInverseEList(TPFTestComponent.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS, Common_TestprofilePackage.TPF_TEST_COMPONENT__TEST_SUITE);
        }
        return testComponents;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getReferencedSuites()
    {
        if (referencedSuites == null)
        {
            referencedSuites = new EObjectResolvingEList(TPFTestSuite.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES);
        }
        return referencedSuites;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getDatapools()
    {
        if (datapools == null)
        {
            datapools = new EObjectResolvingEList(DPLDatapool.class, this, Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS);
        }
        return datapools;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_TEST_SUITE__OPERATIONS:
                    return ((InternalEList)getOperations()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANCES:
                    return ((InternalEList)getInstances()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANTIATIONS:
                    return ((InternalEList)getInstantiations()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
                    return ((InternalEList)getTestObjectives()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
                    if (behavior != null)
                        msgs = ((InternalEObject)behavior).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR, null, msgs);
                    return basicSetBehavior((TPFBehavior)otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
                    return ((InternalEList)getTestCases()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
                    return ((InternalEList)getSUTs()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
                    if (arbiter != null)
                        msgs = ((InternalEObject)arbiter).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER, null, msgs);
                    return basicSetArbiter((TPFArbiter)otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
                    return ((InternalEList)getTestComponents()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_TEST_SUITE__OPERATIONS:
                    return ((InternalEList)getOperations()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANCES:
                    return ((InternalEList)getInstances()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANTIATIONS:
                    return ((InternalEList)getInstantiations()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
                    return ((InternalEList)getTestObjectives()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
                    return basicSetBehavior(null, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
                    return ((InternalEList)getTestCases()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
                    return ((InternalEList)getSUTs()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
                    return basicSetArbiter(null, msgs);
                case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
                    return ((InternalEList)getTestComponents()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST_SUITE__ID:
                return getId();
            case Common_TestprofilePackage.TPF_TEST_SUITE__DESCRIPTION:
                return getDescription();
            case Common_TestprofilePackage.TPF_TEST_SUITE__NAME:
                return getName();
            case Common_TestprofilePackage.TPF_TEST_SUITE__OPERATIONS:
                return getOperations();
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANCES:
                return getInstances();
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANTIATIONS:
                return getInstantiations();
            case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
                return getType();
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
                return getTestObjectives();
            case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
                return getBehavior();
            case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
                return getPersistenceId();
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
                return getTestCases();
            case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
                return getSUTs();
            case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
                return getArbiter();
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
                return getTestComponents();
            case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
                return getReferencedSuites();
            case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
                return getDatapools();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST_SUITE__ID:
                setId((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__NAME:
                setName((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__OPERATIONS:
                getOperations().clear();
                getOperations().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANCES:
                getInstances().clear();
                getInstances().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANTIATIONS:
                getInstantiations().clear();
                getInstantiations().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
                setType((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
                getTestObjectives().clear();
                getTestObjectives().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
                setBehavior((TPFBehavior)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
                setPersistenceId((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
                getTestCases().clear();
                getTestCases().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
                getSUTs().clear();
                getSUTs().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
                setArbiter((TPFArbiter)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
                getTestComponents().clear();
                getTestComponents().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
                getReferencedSuites().clear();
                getReferencedSuites().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
                getDatapools().clear();
                getDatapools().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST_SUITE__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__OPERATIONS:
                getOperations().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANCES:
                getInstances().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANTIATIONS:
                getInstantiations().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
                setType(TYPE_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
                getTestObjectives().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
                setBehavior((TPFBehavior)null);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
                setPersistenceId(PERSISTENCE_ID_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
                getTestCases().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
                getSUTs().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
                setArbiter((TPFArbiter)null);
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
                getTestComponents().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
                getReferencedSuites().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
                getDatapools().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST_SUITE__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_TestprofilePackage.TPF_TEST_SUITE__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_TestprofilePackage.TPF_TEST_SUITE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_TestprofilePackage.TPF_TEST_SUITE__OPERATIONS:
                return operations != null && !operations.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANCES:
                return instances != null && !instances.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__INSTANTIATIONS:
                return instantiations != null && !instantiations.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE:
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES:
                return testObjectives != null && !testObjectives.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR:
                return behavior != null;
            case Common_TestprofilePackage.TPF_TEST_SUITE__PERSISTENCE_ID:
                return PERSISTENCE_ID_EDEFAULT == null ? persistenceId != null : !PERSISTENCE_ID_EDEFAULT.equals(persistenceId);
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_CASES:
                return testCases != null && !testCases.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__SU_TS:
                return suTs != null && !suTs.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__ARBITER:
                return arbiter != null;
            case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_COMPONENTS:
                return testComponents != null && !testComponents.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__REFERENCED_SUITES:
                return referencedSuites != null && !referencedSuites.isEmpty();
            case Common_TestprofilePackage.TPF_TEST_SUITE__DATAPOOLS:
                return datapools != null && !datapools.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class baseClass)
    {
        if (baseClass == TPFTest.class)
        {
            switch (derivedFeatureID)
            {
                case Common_TestprofilePackage.TPF_TEST_SUITE__TYPE: return Common_TestprofilePackage.TPF_TEST__TYPE;
                case Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES: return Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES;
                case Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR: return Common_TestprofilePackage.TPF_TEST__BEHAVIOR;
                default: return -1;
            }
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class baseClass)
    {
        if (baseClass == TPFTest.class)
        {
            switch (baseFeatureID)
            {
                case Common_TestprofilePackage.TPF_TEST__TYPE: return Common_TestprofilePackage.TPF_TEST_SUITE__TYPE;
                case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES: return Common_TestprofilePackage.TPF_TEST_SUITE__TEST_OBJECTIVES;
                case Common_TestprofilePackage.TPF_TEST__BEHAVIOR: return Common_TestprofilePackage.TPF_TEST_SUITE__BEHAVIOR;
                default: return -1;
            }
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append(type);
        result.append(", persistenceId: ");
        result.append(persistenceId);
        result.append(')');
        return result.toString();
    }

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getISystemsUnderTest()
	 */
	public List getISystemsUnderTest() {
		return (List)getSUTs();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getITestCases()
	 */
	public List getITestCases() {
		return (List)getTestCases();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getITestComponents()
	 */
	public List getITestComponents() {
		return (List)getTestComponents();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITest#getImplementor()
	 */
	public IImplementor getImplementor() {
		
		return (TPFBehaviorImpl)getBehavior();
	}

	private TPFBehavior getDeployableBehavior()
	{
		// This method currently takes the first behavior of the TestComponent, since every
		// behavior should point to the same deployable entity.
		return (TPFBehaviorImpl)getBehavior();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getLocation()
	 */
	public String getLocation() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getLocation();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getOwner()
	 */
	public ITest getOwner() {
		return this;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#getResource()
	 */
	public String getResource() {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			return behavior.getResource();
		}
		else 
		{
			return "";
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setLocation(java.lang.String)
	 */
	public void setLocation(String location) {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			behavior.setLocation(location);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IDeployableComponent#setResource(java.lang.String)
	 */
	public void setResource(String resource) {
		TPFBehaviorImpl behavior = (TPFBehaviorImpl)getDeployableBehavior();
		if ( behavior != null )
		{
			behavior.setResource(resource);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITest#getVariables()
	 */
	public List getVariables() {
		return getInstances();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITestSuite#getIReferencedSuites()
	 */
	public List getIReferencedSuites() {
		return getReferencedSuites();
	}

} //TPFTestSuiteImpl
