package org.eclipse.hyades.logging.java;

import java.util.logging.Filter;
import java.util.logging.LogRecord;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Implementation of the Java Logging <code>java.util.logging.Filter</code>
 * interface used to provide control over what is logged at a more 
 * granular level than logging level for both <code>java.util.logging.Logger</code>
 * instances and <code>java.util.logging.Handler</code> instances.
 * <p>
 * Only <code>org.eclipse.hyades.logging.java.CommonBaseEventLogRecord</code>
 * instances are logged when this filter is utilized.
 * <p>
 * An instance of this class will be returned from the <code>getFilter()</code> APIs on 
 * <code>java.util.logging.Logger</code> instances and/or run-time 
 * <code>java.util.logging.Handler</code> instances.
 * <p>
 * The default <code>java.util.logging.LogManager</code> implementation
 * uses the following configuration variable in the default 
 * &lt;JRE&gt;/lib/logging.properties configuration file to load configuration 
 * for <code>java.util.logging.Logger</code> instances and/or 
 * run-time <code>java.util.logging.Handler</code> instances:
 * <p>
 * <logger and/or handler name>.filter = org.eclipse.hyades.logging.java.CommonBaseEventFilter
 * <p>
 * Alternatively, an instantiation of this filter class may be set directly to 
 * <code>java.util.logging.Logger</code> instances and/or run-time 
 * <code>java.util.logging.Handler</code> instances by using the <code>setFilter()</code> 
 * APIs.
 * <p>
 * NOTE: The Java Logging classes must be on the CLASSPATH at run-time to
 * utilize this filter class.
 * <p>
 *  
 * 
 * @author		Paul Slauenwhite
 * @version	    July 21, 2004
 * @since       March 7, 2003
 * @see		    java.util.logging.Filter
 * @see		    java.util.logging.LogRecord
 * @see		    org.eclipse.hyades.logging.java.CommonBaseEventLogRecord
 */
public class CommonBaseEventFilter implements Filter {

    /**
     * Checks if the parameter <code>java.util.logging.LogRecord</code> is loggable.  
     * <p>
     * To be loggable, the parameter <code>java.util.logging.LogRecord</code> must be an 
     * instance of <code>org.eclipse.hyades.logging.java.CommonBaseEventLogRecord</code>.
     * <p>
     * 
     * @param logRecord The <code>java.util.logging.LogRecord</code> to be checked if it is loggable.
     * @return True if the parameter <code>java.util.logging.LogRecord</code> is an instance of <code>org.eclipse.hyades.logging.java.CommonBaseEventLogRecord</code>, otherwise false.
     */
    public boolean isLoggable(LogRecord logRecord) {
        return (logRecord instanceof CommonBaseEventLogRecord);
    }
}
