/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter;

/**
 * IStatus is the interface to retrieve the status of an adapter entity
 *
 */
public interface IStatus {

	/**
	 * @return Returns the name of the entity this status is for.
	 */
	public String getName();

	/**
	 * @return Returns whether this entity is active or not.
	 */
	public boolean isActive();

	/**
	 * Returns the count of the number of items processed by this entity
	 * @return Returns the itemsProcessedCount.
	 */
	public int getItemsProcessedCount();

	/**
	 * Gets the status of children entities
	 * @return Returns the status of children.
	 */
	public IStatus[] getChildrenStatus();

	/**
	 * Gets the status of a child entities
	 * @param name name of the child
	 * @return Returns the status of child.
	 */
	public IStatus getChildStatus(String name);

	/**
	 * Gets the elpased time since the entity started executing in milliseconds
	 * @return elapsed time in milliseconds.
	 */
	public long getElapsedTimeInMilliseconds();

}
