/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.impl;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;

/**
 * 
 * @version 0.1
 */
public class Sensor extends ProcessUnit implements ISensor
{
	private String type = null;
	protected int maximumBlocking = 1;
	protected boolean flushingMode = false;
	private boolean initialized = false;
	
	/* The size of the confidence buffer for determining if an append has occured within the file */
	protected int confidenceBufferSize=1024;
	
	/* The size of the fotter within the file which contains variable content */
	protected int fileFooterSize=90;
	
	public Sensor()
	{
		super();
	}
	/**
	 * @see org.eclipse.hyades.logging.adapter.ISensor#getNext()
	 */
	public Object[] getNext()
	{
	    CommonBaseEvent event = getEventFactory().createCommonBaseEvent();
	    
	    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Sensor_getNext_INFO_");
	    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{getUniqueID()});							    

	    event.setSeverity(CommonBaseEvent.SEVERITY_INFORMATION);

	    log(event);
	    
		return null;
	}
	public Object[] testGetNext()
	{
		return null;
	}
	public Object[] flush()
	{
		if (!initialized) {
			return null;
		}
		flushingMode = true;
		Object[] temp = getNext();
		flushingMode = false;
		return temp;
	}
	/**
	  * @see org.eclipse.hyades.logging.adapter.IComponent#update()
	 */
	public void update() throws AdapterInvalidConfig
	{
		super.update();
		
		Element element = getConfiguration();
		setType(element.getAttribute(Messages.getString("HyadesGAtypeAttributeName")));
		if (element.hasAttribute(Messages.getString("HyadesGAmaximumBlockingAttributeName"))) {
			maximumBlocking =
				Integer
					.valueOf(element.getAttribute(Messages.getString("HyadesGAmaximumBlockingAttributeName")))
					.intValue();
		}
		if(element.hasAttribute(Messages.getString("HyadesGAconfidenceBufferSizeAttributeName"))) {
			confidenceBufferSize =
				Integer
					.valueOf(element.getAttribute(Messages.getString("HyadesGAconfidenceBufferSizeAttributeName")))
					.intValue();
			
		}
		if(element.hasAttribute(Messages.getString("HyadesGAfileFooterSizeAttributeName"))) {
			fileFooterSize =
				Integer
					.valueOf(element.getAttribute(Messages.getString("HyadesGAfileFooterSizeAttributeName")))
					.intValue();
			
		}
					
		initialized = true;
	}
	/**
	  * @see org.eclipse.hyades.logging.adapter.ISensor#setType(String)
	 */
	public void setType(String newType)
	{
		type = newType;
	}
	/**
	  * @see org.eclipse.hyades.logging.adapter.ISensor#getType()
	 */
	public String getType()
	{
		return type;
	}
}
