/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/**
 * Insert the type's description here.
 * Creation date: (09/28/2000 12:00:37 PM)
 * @author: Administrator
 */
public class OpenExecutionStatisticAction extends OpenTraceViewAction
{
	
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenExecutionStatisticAction() {
	super("");
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 */
public OpenExecutionStatisticAction(String label) {
	super(label);
}
/**
 * OpenReferencePatternView constructor comment.
 * @param label java.lang.String
 * @param image com.ibm.jface.parts.IImage
 */
public OpenExecutionStatisticAction(String label, ImageDescriptor image) {
	super(label, image);
}

/**
 * 
 */   
public void run()
{
	IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
			
	try
	{
		IWorkbenchPage persp = UIPlugin.getActivePage();     
		TraceViewer view = (TraceViewer)persp.showView("org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticViewer");
				
		if(view != null){
			 view.addViewPage(getMofObject(), true);			 
		}			 					 
	}
	catch(Exception e)
	{
		String msg = TraceUIPlugin.getString("STR_OPEN_ST_PATTERN_ERROR_");                 

		Status err = new Status(Status.WARNING, ResourcesPlugin.PI_RESOURCES, IResourceStatus.INTERNAL_ERROR, e.toString(), null ); 

		ErrorDialog.openError(window.getShell(),
				msg,
				"", // no special message
				err);
		
		e.printStackTrace();    
	}                               
	  
}

/*
 * 
 */
public void run(IAction action)
{
	run();
}

}
