/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticViewer;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenMemoryStatisticViewAction extends OpenTraceViewAction {

	public OpenMemoryStatisticViewAction() {
		super("");
	}

	public OpenMemoryStatisticViewAction(String label) {
		super(label);
	}

	public OpenMemoryStatisticViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	public boolean isVisibleForType(Object mofObject) {
		return true;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IWorkbenchWindow window =
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			MemoryStatisticViewer view =
				(MemoryStatisticViewer) persp.showView(
					"org.eclipse.hyades.trace.views.adapter.internal.MemoryStatisticViewer");
			
			if(view != null){
				 view.addViewPage(getMofObject(), true);
			}

		} catch (Exception e) {
			String msg =
				TraceUIPlugin.getString("STR_OPEN_MEMORY_STATISTIC_VIEW_ERROR_");
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",
			// no special message
			err);

			e.printStackTrace();
		}

	}

	public void run(IAction action) {
		run();
	}
}
