/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.GraphColorDialog;
import org.eclipse.jface.action.*;
import org.eclipse.ui.part.IPage;

/**
 * Insert the type's description here.
 * Creation date: (06/14/2000 2:49:21 PM)
 * @author: Administrator
 */
public class SinglePatternViewer extends TraceViewer
{
	protected Action _next;
	protected Action _previous;
	protected Action _update;
	protected Action _caller;
	protected Action _callee;	
	protected Action _openSource;
    protected Action _showRawTime;
	private Action _zoomInAction;
	private Action _zoomOutAction;
    private Action _stdSelectAction;	
    protected Action _showCompensatedTime;
    private   boolean _stdSelect = true;
	private   boolean _zoomIn = false;
	private   boolean _zoomOut = false;
	

/**
 * HistogramEditor constructor comment.
 */
public SinglePatternViewer() {
	super();
}
/**
 * Insert the method's description here.
 * Creation date: (6/6/2001 5:31:32 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action callee() {
	return _callee;
}
/**
 * Insert the method's description here.
 * Creation date: (6/6/2001 5:31:32 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action caller() {
	return _caller;
}
/**
 * Insert the method's description here.
 * Creation date: (08/01/2000 4:17:37 PM)
 * @return com.ibm.itp.jinsight.adapter.TraceViewerPage
 */
public TraceViewerPage createPage(EObject mofObject)
{
	return new SinglePatternPage(mofObject, this);
}
/**
 * @see IWorkbenchPart#dispose
 */
public void dispose()
{
	Enumeration pages = _pages.elements(); 
	while(pages.hasMoreElements())
	{
		IPage page = (IPage) pages.nextElement();

		if(page instanceof SinglePatternPage)
		  ((SinglePatternPage)page).dispose();
	}

	_openSource = null;
	_showCompensatedTime = null;
	_showRawTime = null;
	_stdSelectAction = null;
	_zoomInAction = null;
	_zoomOutAction = null;
	_previous = null;
	_next = null;
	_callee = null;
	_caller = null;

	super.dispose();
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 2:54:24 PM)
 */
public void makeActions()
{
	if(isInitializedMenu())
	  return; //create the toolbar only once

	initializedMenu(true);

    String compTime = TraceUIPlugin.getString("STR_COMPENSATED_TIME");
	_showCompensatedTime = new Action(compTime)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.TIME_OPTION, TraceConstants.COMPENSATED_TIME);
			
			TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
			
		}
	};      
	_showCompensatedTime.setText(compTime);
	_showCompensatedTime.setDescription(compTime);
	_showCompensatedTime.setToolTipText(compTime);   
	int ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	_showCompensatedTime.setChecked(ref == TraceConstants.COMPENSATED_TIME);         
	
    String rawTime = TraceUIPlugin.getString("STR_RAW_TIME");
	_showRawTime = new Action(rawTime)
	{
		public void run()
		{
			TraceUIPlugin.getDefault().getPreferenceStore()
				.setValue(TraceConstants.TIME_OPTION, TraceConstants.RAW_TIME);
			
			TraceUIPlugin.getDefault().notifyTimeChangedEventListener();
			
		}
	};      
	_showRawTime.setText(rawTime);
	_showRawTime.setDescription(rawTime);
	_showRawTime.setToolTipText(rawTime);   
	ref = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	_showRawTime.setChecked(ref == TraceConstants.RAW_TIME);         

    String strPrev = TraceUIPlugin.getString("STR_PREVIOUS");
	_previous = new Action(strPrev)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			page.getView().previous();
		}
	};      
	_previous.setText(strPrev);
	TracePluginImages.setImageDescriptors(_previous,TracePluginImages.T_LCL,TracePluginImages.IMG_PREV);				
	_previous.setDescription(strPrev);
	_previous.setToolTipText(TraceUIPlugin.getString("STR_PREV_TEXT"));            

    String strNext = TraceUIPlugin.getString("STR_NEXT");
	_next = new Action(strNext)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			page.getView().next();
		}
	};      
	_next.setText(strNext);
	TracePluginImages.setImageDescriptors(_next,TracePluginImages.T_LCL,TracePluginImages.IMG_NEXT);		
	_next.setDescription(strNext);
	_next.setToolTipText(TraceUIPlugin.getString("STR_NEXT_TEXT"));            
		
    String strHome = TraceUIPlugin.getString("STR_HOME");					
	_update = new Action(strHome)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			page.getView().updateUI();
			page.getView().updateButtons();
		}
	};
	_update.setText(strHome);
	TracePluginImages.setImageDescriptors(_update,TracePluginImages.T_TOOL,TracePluginImages.IMG_HOME);	
	_update.setDescription(strHome);
	_update.setToolTipText(strHome);         

	String strStdSelect = TraceUIPlugin.getString("STR_STD_SELECT");				
	_stdSelectAction = new Action(strStdSelect)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			_stdSelect = true;
			_zoomIn = !_stdSelect;
			_zoomOut = !_stdSelect;		 

			_stdSelectAction.setChecked(true);
			_zoomInAction.setChecked(false);			
			_zoomOutAction.setChecked(false);
				
			page.getView().zoomIn(_zoomIn);
			page.getView().zoomOut(_zoomOut);												
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};
	
	_stdSelectAction.setText(strStdSelect);
	TracePluginImages.setImageDescriptors(_stdSelectAction,TracePluginImages.T_LCL,TracePluginImages.IMG_RESTORE_ORG);		
	_stdSelectAction.setDescription(strStdSelect);
	_stdSelectAction.setToolTipText(strStdSelect);
	
	String strZoomIn = TraceUIPlugin.getString("STR_ZOOM_IN");				
	_zoomInAction = new Action(strZoomIn)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			_zoomIn = isChecked();
			if (_zoomIn==false)
			{
				_stdSelect = true;
			}
			else {
				_stdSelect = !_zoomIn;
				_zoomOut = !_zoomIn;
			}			 
			if(_zoomIn) 
			{				
				_stdSelectAction.setChecked(false);
				_zoomOutAction.setChecked(false);
			}
			else
				_stdSelectAction.setChecked(true);
					
			page.getView().zoomIn(_zoomIn);										
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};

	_zoomInAction.setText(strZoomIn);
	TracePluginImages.setImageDescriptors(_zoomInAction,TracePluginImages.T_LCL,TracePluginImages.IMG_ZOOMIN);		
	_zoomInAction.setDescription(strZoomIn);
	_zoomInAction.setToolTipText(strZoomIn);         

    String strZoomOut = TraceUIPlugin.getString("STR_ZOOM_OUT");
	_zoomOutAction = new Action(strZoomOut)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  			
			_zoomOut = isChecked();
			if (_zoomOut==false)
			{
				_stdSelect = true;
			}
			else {
				_stdSelect = !_zoomOut;
				_zoomIn = !_zoomOut;
			}
			 
			if(_zoomOut) 
			{
				_stdSelectAction.setChecked(false);
				_zoomInAction.setChecked(false);
			}
			else
				_stdSelectAction.setChecked(true);
			
			page.getView().zoomOut(_zoomOut);						
		}
		
		public int getStyle() { return IAction.AS_CHECK_BOX; }
		
	};

	_zoomOutAction.setText(strZoomOut);
	TracePluginImages.setImageDescriptors(_zoomOutAction,TracePluginImages.T_LCL,TracePluginImages.IMG_ZOOMOUT);			
	_zoomOutAction.setDescription(strZoomOut);   
	_zoomOutAction.setToolTipText(strZoomOut);                   

    String strCaller = TraceUIPlugin.getString("STR_CALLER");
	_caller = new Action(strCaller)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			page.getView().showCaller();
		}
	};

	_caller.setText(strCaller);
	TracePluginImages.setImageDescriptors(_caller,TracePluginImages.T_LCL,TracePluginImages.IMG_CALLER);	
	_caller.setDescription(strCaller);
	_caller.setToolTipText(strCaller);         

    String strCalee = TraceUIPlugin.getString("STR_CALLEE");
	_callee = new Action(strCalee)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;
			  
			page.getView().showCallee();
		}
	};

	_callee.setText(strCalee);
	TracePluginImages.setImageDescriptors(_callee,TracePluginImages.T_LCL,TracePluginImages.IMG_CALLEE);	
	_callee.setDescription(strCalee);
	_callee.setToolTipText(strCalee);         
	
   String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");											
	_openSource = new Action(openSourceStr)
	{
		public void run()
		{
			SinglePatternPage page = (SinglePatternPage)getCurrentPage();

			if(page == null)
			  return;

			page.getView().openSource();      
		}
	};

	_openSource.setText(openSourceStr);
	TracePluginImages.setImageDescriptors(_openSource,TracePluginImages.T_TOOL,TracePluginImages.IMG_SOURCE);	
	_openSource.setDescription(openSourceStr);   
	_openSource.setToolTipText(openSourceStr);
	
	Action openColorDialog = new Action(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"))
	{
		public void run()
		{
			GraphColorDialog dialog =
				new GraphColorDialog(
					getViewSite().getShell(),
					TraceUIPlugin.getString("STR_GRAPH_COLOR_DLG"),
					null);
			dialog.open();
		}
	};

	openColorDialog.setText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));
	TracePluginImages.setImageDescriptors(openColorDialog,TracePluginImages.T_TOOL,TracePluginImages.IMG_COLORS);	
	openColorDialog.setDescription(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));   
	openColorDialog.setToolTipText(TraceUIPlugin.getString("OPEN_COLOR_DLG_TEXT"));

	IToolBarManager tbm = getViewSite().getActionBars().getToolBarManager();
	IMenuManager menu = getViewSite().getActionBars().getMenuManager();
	MenuManager submenu = new MenuManager(TraceUIPlugin.getString("STR_SHOW_TIME"));
	menu.add(submenu);

	submenu.add(_showCompensatedTime);
	submenu.add(_showRawTime);
	
	tbm.removeAll();
	tbm.add(new Separator());	 				
	tbm.add(_openSource);
	tbm.add(new Separator());	 	
	tbm.add(_caller);
	tbm.add(_callee);
	tbm.add(new Separator());	 			
	tbm.add(_previous);
	tbm.add(_next);
	tbm.add(new Separator());
	tbm.add(_stdSelectAction);	 
	tbm.add(_zoomInAction);
	tbm.add(_zoomOutAction);
	tbm.add(new Separator());
	tbm.add(_update);
	tbm.add(new Separator());
    tbm.add(openColorDialog);
						

	// require update because toolbar control has been created by this point,
	// but manager does not update it automatically once it has been created
	getViewSite().getActionBars().updateActionBars();           
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 5:15:22 PM)
 * @return com.ibm.jface.action.Action
 */
public Action next() {
	return _next;
}
/**
 * Insert the method's description here.
 * Creation date: (8/21/2001 4:20:37 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action openSource() {
	return _openSource;
}
/**
 * Insert the method's description here.
 * Creation date: (1/11/2001 5:15:22 PM)
 * @return com.ibm.jface.action.Action
 */
public Action previous() {
	return _previous;
}
/**
 * Insert the method's description here.
 * Creation date: (10/5/2001 11:42:53 AM)
 */
public void setFocus() {
	
	if (getCurrentPage()!=null)
	((SinglePatternPage)getCurrentPage()).setFocus();
}
/**
 * Insert the method's description here.
 * Creation date: (08/14/2000 5:50:25 PM)
 */
public Action updateBtn()
{
	return _update;
}

/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:25:59 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action baseTime() {
	return _showCompensatedTime;
}
/**
 * Insert the method's description here.
 * Creation date: (8/1/2001 6:25:59 PM)
 * @return org.eclipse.jface.action.Action
 */
public Action rawTime() {
	return _showRawTime;
}

/*
 * Returns true if the object can be viewed using this type of view 
 * 
 */
 public boolean isValidObject(Object object)
 {
 	if(object == null)
 	  return false;
 	  
 	if(object instanceof TRCMonitor || object instanceof TRCNode)
 	   return true;
 	   
 	if(object instanceof TRCAgentProxy && ((TRCAgentProxy)object).getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))  
 	     return true;
 	
	if(object instanceof TRCProcessProxy)
	{
		EList agents = ((TRCProcessProxy)object).getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
			if(agent == null || agent.eIsProxy())
				continue;
			if(agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
				return true;
		}		
	}
 	  
 	return false;
 }

/*
 * Returns the object that should be viewd if
 * true if the selObject is selected in the monitors view
 * For example, if the process node is selected, the view should display
 * the profiling data if trace collects profiling data
 * 
 */
public EObject getObjectToView(EObject selObject)
{
	if(selObject == null)
	  return selObject;

	if(selObject instanceof TRCProcessProxy)
	{
		int nbOfAgents = 0;
		TRCAgentProxy a = null;
		EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
		for(int idx=0; idx<agents.size(); idx++)
		{
			TRCAgentProxy agent = (TRCAgentProxy) agents.get(idx);
			if(agent == null || agent.eIsProxy())
				continue;
			if(agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE))
			{
				nbOfAgents++;
				a = agent;
			}
		}
		
		if(nbOfAgents==1)
		  return a;
	}

	return selObject;
}

/*
 * Initial title view 
 */
 public String getViewTitle()
 {
 	return TraceUIPlugin.getString("STR_METH_INVOC_TITLE");
 }
 
  public void initializeActionBar()
 {
	_stdSelectAction.setChecked(true); 	
 }
}
