/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.logicalfolder;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

import org.eclipse.hyades.ui.internal.util.CoreUtil;

/**
 * Element factory for the logical folder.  Also provides the method to 
 * save the save the logical folder in a memento.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public class LogicalFolderFactory 
implements IElementFactory
{
	/*
	 * TAG* constants are used in the IMemento
	 */
	public static final String TAG_NAME = "NAME";
	public static final String TAG_PARENT = "PARENT";
	private static final String TAG_FACTORY_ID = "factoryID";

	/**
	 * Saves information of the logical folder in the memento. 
	 * @param memento
	 * @param logicalFolder
	 */
	public static void save(IMemento memento, LogicalFolder logicalFolder)
	{
		memento.putString(TAG_NAME, logicalFolder.getName());
		
		Object parent = logicalFolder.getParent();
		if(parent == null)
			return;
			
		IPersistableElement persistableElement = null;
		if(parent instanceof IPersistableElement)
			persistableElement = (IPersistableElement)parent;
		else if(parent instanceof IAdaptable)
			persistableElement = (IPersistableElement)((IAdaptable)parent).getAdapter(IPersistableElement.class);
		if(persistableElement == null)
			return;
		
		IMemento parentMemento = memento.createChild(TAG_PARENT);
		parentMemento.putString(TAG_FACTORY_ID, persistableElement.getFactoryId());
		persistableElement.saveState(parentMemento);
	}	

	/**
	 * @see org.eclipse.ui.IElementFactory#createElement(org.eclipse.ui.IMemento)
	 */
	public IAdaptable createElement(IMemento memento)
	{
		String name = memento.getString(TAG_NAME);
		if(name == null)
			return null;
			
		IMemento parentMemento = memento.getChild(TAG_PARENT);
		if(parentMemento != null)
		{
			String factoryId = parentMemento.getString(TAG_FACTORY_ID);
			if(factoryId != null)
			{
				IElementFactory elementFactory = CoreUtil.getElementFactory(factoryId);
				if(elementFactory != null)
				{
					Object parent = elementFactory.createElement(parentMemento);
					if(parent != null)
						return new LogicalFolder(parent, name);
				}
			}
		}
			
		return new LogicalFolder(name);
	}	
}
