package org.eclipse.hyades.logging.adapter.config;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Plugin;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Plugin class for this plugin.
 * <p>
 * 
 * @author Paul E. Slauenwhite
 */
public class AdapterConfigPlugin extends Plugin {

    private static AdapterConfigPlugin instance = null;

    public AdapterConfigPlugin(IPluginDescriptor descriptor) {

        super(descriptor);

        if (instance == null) {
            instance = this;
        }
    }

    public static AdapterConfigPlugin getPlugin() {
        return instance;
    }

    public static ResourceBundle getResourceBundle() {
        try {
            return (getPlugin().getDescriptor().getResourceBundle());
        }
        catch (Exception e) {
        }

        return null;
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }
}
