/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.config.outputters;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.util.Messages;

/**
 * @author smith
 *
 * This class is an outputter to write CBE events created by GLA to an 
 * Apache Commons logger. 
 */
public class AdapterLogOutputter extends StaticParserOutputter {
	
	public void update() throws AdapterInvalidConfig {
		
		/* first get the basic configuration set */
		super.update();

		if (outLogger == null) {
			throw new AdapterInvalidConfig(Messages.getString("HyadesGA_AdapterLogOutputter_No_Logger_ERROR_"));
		}
	}
	/**
	 * Set the output logger.
	 * @param outLogger The outLogger to set.
	 */
	public void setOutLogger(Log outLogger) {
		this.outLogger = outLogger;
	}
}
