/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.config.outputters;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.config.StaticParserWrapper;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.commons.FileLogger;
import org.eclipse.hyades.logging.commons.Logger;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

/**
 * @author eclipse
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class StaticParserOutputter extends Outputter implements IOutputter {

	/* The loader where all of the events will be forwarded */
	protected Log outLogger; 

	public void update() throws AdapterInvalidConfig {
		
		String key = null;

		/* first get the basic configuration set */
		super.update();
			
		// Get the logger key from the outputter properties
		Hashtable outputterProperties = getProperties();
		if (outputterProperties != null && !outputterProperties.isEmpty()) {
			key = (String)outputterProperties.get(Messages.getString("HyadesGAStaticParserLoggerKeyName"));				
		}

		if(key!=null) {
			outLogger = StaticParserWrapper.getLogInstance(key);
		}
	}


	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#processEventItems(java.lang.Object[])
	 */
	public Object[] processEventItems(Object[] msgs) {
		
		/* If we have no input or we have nowhere to put it then we will just return what we got. */
		if (msgs==null || outLogger==null) {
			return msgs;
		}
		return processCBEs((CommonBaseEvent[]) msgs);

	}

	/**
	 * Process the CBE events passed in.
	 * @param events CBE events to process
	 * @return CommonBaseEvent[]
	 */
	private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
		
		if (events != null) {
			for (int i = 0; i < events.length; i++)	{
				if (events[i] != null) {
								
					try {
						// Write CBE to logging agent
						outLogger.trace(events[i]);
						incrementItemsProcessedCount();
					} catch (Exception ioe) {
						    CommonBaseEvent event = getEventFactory().createCommonBaseEvent();
						    event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Logging_Agent_Write_ERROR_");
						    String loggerName = "unknown";
						    if (outLogger instanceof Logger) {
						    	loggerName = ((Logger)outLogger).getName();
						    }
						    else if (outLogger instanceof FileLogger) {
						    	loggerName = ((FileLogger)outLogger).getName();
						    }
						    event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{getUniqueID(),loggerName});							    
						    event.setSeverity(CommonBaseEvent.SEVERITY_FATAL);
							
						    log(event);
					}
				}
			}
			return events;
		}
		return null;
	}

		

	/**
	 * @see org.eclipse.hyades.logging.adapter.IProcessUnit#testProcessEventItems(java.lang.Object[])
	 */
	public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
		if(!(msgs instanceof CommonBaseEvent[])) {
			throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
		}
		return msgs;
	}	
	
}
