/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.statistical.ui.editor.internal;


import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.ImageManager;
import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.internal.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.events.*;


public class AlertTableMultiPanel extends Composite implements SelectionListener {
	
	int curr_index = 0;
	AlertAction[] actions;
	
	Label error_img;
	Label error_label;
	
	List list;
	Button list_add;
	Button list_remove;
	
	AlertTablePanel alertpanel;

	public AlertTableMultiPanel(Composite parent, AlertAction[] actions, String description) {
		super(parent,SWT.SHADOW_ETCHED_IN);

		this.actions = actions;
		
		initGraphics(description);
		initEventHandling();

		loadFromIndex();
	}
	
	private void setErrorMessage(String msg) {
		if (msg == null) {
			error_img.setImage(null);
			error_label.setText("        ");
			layout(true);
			error_label.redraw();
			error_img.redraw();
		} else {
			error_label.setText(msg);
			EditorPlugin.DBG.warning(msg);
			error_img.setImage(EditorPlugin.img.getImage(ImageManager.IMG_ERROR));
			layout(true);
			error_label.redraw();
			error_img.redraw();
		}
	}
	
	private boolean saveFromIndex() {
		if (alertpanel.getEnabled()) {
			//there is a valid action being configured, save it
			try {
				actions[curr_index] = alertpanel.getConfiguredAction();
				setErrorMessage(null);
				return true;
			} catch (InvalidDataException x) {
				list.setItem(curr_index,alertpanel.getCurrentDescription());
				setErrorMessage(EditorPlugin.getString("ERROR_LABEL")+x.getMessage());
				list.setSelection(curr_index);
				return false;
			}
		} else {
			return true;
		}
	}
	
	private void loadFromIndex() {
		
		setErrorMessage(null);
		
		//set up list
		String[] summaries = new String[actions.length];
		for (int i = 0; i < actions.length; i++) {
			summaries[i] = actions[i].getDescription();
		}
		
		int index = list.getSelectionIndex();
		list.setItems(summaries);
		if (index >= 0 && index < summaries.length) {
			list.setSelection(index);
		}
		
		//show the selected action for configuration
		if (actions.length == 0 || curr_index < 0 || curr_index >= actions.length) {
			alertpanel.setConfiguredAction(AlertRegistry.getProvider(EditorPlugin.getString("ALERT_ACTION_NAME_DONOTHING")).newAlertAction());
			alertpanel.setEnabled(false);
		} else {
			alertpanel.setEnabled(true);
			alertpanel.setConfiguredAction(actions[curr_index]);
		}
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		Object o = e.getSource();
		if (o == list) {
			if (saveFromIndex()) {
				curr_index = list.getSelectionIndex();
				loadFromIndex();
			}
		} else if (o == list_add) {

			if (saveFromIndex()) {
				AlertAction[] tmp = new AlertAction[actions.length+1];
	
				int index = actions.length;
				System.arraycopy(actions,0,tmp,0,index);
				tmp[index] = AlertRegistry.getProviders()[0].newAlertAction();
				
				actions = tmp;
				curr_index = index;
				loadFromIndex();
				
				list.setSelection(curr_index);
			}
		} else if (o == list_remove) {
			AlertAction[] tmp = new AlertAction[actions.length-1];
			if (curr_index > 0) {
				System.arraycopy(actions,0,tmp,0,curr_index);
			}
			if (curr_index < actions.length-1) {
				System.arraycopy(actions,curr_index+1,tmp,curr_index,actions.length-(curr_index+1));
			}
			actions = tmp;
			curr_index = 0;
			loadFromIndex();
		}
	}

	private void initEventHandling() {
		list.addSelectionListener(this);
		list_add.addSelectionListener(this);
		list_remove.addSelectionListener(this);
	}
	
	private void initGraphics(String description) {
		setLayoutData(GData.getGridData(true,true,-1,-1,1,1,GridData.FILL,GridData.FILL));
		setLayout(new GridLayout(2,false));
		
		Composite error_tmp = new Composite(this,SWT.NONE);
		error_tmp.setLayout(new GridLayout(2,false));
		error_tmp.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
			
			error_img = new Label(error_tmp,SWT.NONE);
			error_img.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
			error_label = new Label(error_tmp,SWT.NONE);
			error_label.setText("            ");
			error_label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));

		list = new List(this,SWT.BORDER|SWT.SINGLE);
		list.setLayoutData(GData.getGridData(true,true,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		Composite list_tmp = new Composite(this,0);
		list_tmp.setLayout(new GridLayout(1,true));
		list_tmp.setLayoutData(GData.getGridData(false,true,-1,-1,1,1,GridData.FILL,GridData.BEGINNING));
		
			list_add = new Button(list_tmp,SWT.NONE);
			list_add.setText(EditorPlugin.getString("ALERT_ACTION_ADD"));
			list_add.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.BEGINNING));
			list_remove = new Button(list_tmp,SWT.NONE);
			list_remove.setText(EditorPlugin.getString("ALERT_ACTION_REMOVE"));
			list_remove.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.BEGINNING));
		
		alertpanel = new AlertTablePanel(this,description);
		list_remove.setLayoutData(GData.getGridData(true,true,-1,-1,2,1,GridData.FILL,GridData.FILL));
	}
	
	private int getProviderIndex(String name) {
		String[] provider_names = AlertRegistry.getProviderNames();
		for (int i = 0; i < provider_names.length; i++) {
			if (name.equals(provider_names[i])) {
				return i;
			}
		}
		return 0;
	}
	
	public AlertAction[] getConfiguredActions() throws InvalidDataException {
		if (!saveFromIndex()) {
			throw new InvalidDataException(error_label.getText());
		} else {
			return actions;
		}
	}

}