/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.InvalidTableValueException;
import org.eclipse.hyades.statistical.ui.widgets.table.internal.*;

import org.eclipse.hyades.statistical.ui.EditorPlugin;

import java.util.*;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.swt.widgets.*;

import org.eclipse.swt.graphics.*;
import org.eclipse.swt.events.*;

public class GraphTable extends TableAdapter implements DisposeListener, GraphSelectionSource, SelectionListener, FocusListener
{

	public static final int VAL_GRAPH = 0;
	public static final int VAL_NAME = 1;
	public static final int VAL_DESC = 2;
	public static final int VAL_RGB = 3;
	public static final int VAL_WIDTH = 4;
	public static final int VAL_STYLE = 5;
	public static final int VAL_XSLIDER = 6;
	public static final int VAL_YSLIDER = 7;
//	public static final int VAL_SCALING = 8;

	private static final int COL_NAME = 0;
	private static final int COL_DESC = 1;
	private static final int COL_RGB = 2;
	private static final int COL_WIDTH = 3;
	private static final int COL_STYLE = 4;
	private static final int COL_XSLIDER = 5;
	private static final int COL_YSLIDER = 6;
//	private static final int COL_SCALING = 7;
	private static final int COL_GRAPH = 7;
	
//	private Composite parent;

	private Control graph_control;

	private int style;
	private Vector datas = new Vector();
	private boolean editable = true;
	private Vector listeners = new Vector();
	
//	private ComboBoxCellEditor comboBoxWidthCellEditor;
//	private ComboBoxCellEditor comboBoxStyleCellEditor;
//	private ComboBoxCellEditor comboBoxSliderXCellEditor;
//	private ComboBoxCellEditor comboBoxSliderYCellEditor;
//	private ColorCellEditor colorCellEditor;

	private Integer[] sliderXChoices = new Integer[] {
			new Integer(1),
		};
	private String[] sliderXChoicesString = new String[] {
			"1",
		};
	private Integer[] sliderYChoices = new Integer[] {
			new Integer(1),
		};
	private String[] sliderYChoicesString = new String[] {
			"1",
		};

	private Integer[] widthChoices = new Integer[] {
			new Integer(1),
			new Integer(2),
			new Integer(3),
			new Integer(4),
			new Integer(5),
			new Integer(6),
			new Integer(7),
			new Integer(8),
			new Integer(9),
			new Integer(10),
		};
	private String[] widthChoicesString = new String[] {
			"1","2","3","4","5","6","7","8","9","10"
		};

	private Integer[] styleChoices = new Integer[] {
			new Integer(SWT.LINE_SOLID),
			new Integer(SWT.LINE_DOT),
			new Integer(SWT.LINE_DASH),
			new Integer(SWT.LINE_DASHDOT),
			new Integer(SWT.LINE_DASHDOTDOT),
	};
	private String[] styleChoicesString = new String[] {
		EditorPlugin.getString("GRAPH_LINE_SOLID"),
		EditorPlugin.getString("GRAPH_LINE_DOT"),
		EditorPlugin.getString("GRAPH_LINE_DASH"),
		EditorPlugin.getString("GRAPH_LINE_DASH_DOT"),
		EditorPlugin.getString("GRAPH_LINE_DASH_DOT_DOT"),
	};

	public void addListener(GraphTableListener newListener) {
		listeners.add(newListener);
	}

	public void notifyListenersEdit(Graph g) {
		for (int v = 0; v < listeners.size(); v++)
		{
			GraphTableListener TCL = (GraphTableListener) (listeners.elementAt(v));
			TCL.graphEdited(g);
		}
	}
	public void notifyListenersSelect(Graph g) {
		for (int v = 0; v < listeners.size(); v++)
		{
			GraphTableListener TCL = (GraphTableListener) (listeners.elementAt(v));
			TCL.graphSelected(g);
		}
	}

	public void setEditable(boolean newValue)
	{
		editable = newValue;
	}

	public void widgetDisposed(DisposeEvent e) {
		dispose();
	}
	
	public Object[] getElements(Object inputObject) {
		return datas.toArray();
	}
	
	public void setSelectedIndex(int i) {
//		getViewer().setSelection(new StructuredSelection(datas.get(i)));
		getViewer().getTable().setFocus();
		getViewer().getTable().setSelection(i);
		getViewer().getTable().showSelection();
		getViewer().getTable().redraw();
	}
	
	public GraphTable(Composite parent, Object[][] values, Control graph_control)
	{
		super(parent);
		this.graph_control = graph_control;

		parent.addDisposeListener(this);

		String[] names = new String[] {
			EditorPlugin.getString("TABLE_COLUMN_NAME"),
			EditorPlugin.getString("TABLE_COLUMN_DESCRIPTION"),
			EditorPlugin.getString("TABLE_COLUMN_COLOR"),
			EditorPlugin.getString("TABLE_COLUMN_WIDTH"),
			EditorPlugin.getString("TABLE_COLUMN_STYLE"),
			EditorPlugin.getString("TABLE_COLUMN_HSLIDER"),
			EditorPlugin.getString("TABLE_COLUMN_VSLIDER"),
//			EditorPlugin.getString("TABLE_COLUMN_MULTIPLIER"),
			EditorPlugin.getString("TABLE_COLUMN_ADVANCED"),
		};		
		
		int[] types = new int[] {
			LABEL,
			LABEL,
			COLOR,
			CHOICE,
			CHOICE,
			CHOICE,
			CHOICE,
//			TEXT,
			CUSTOM,
		};
		
		setColumnNames(names);	
		setColumnTypes(types);
		
		setColumnEditor(new GraphTableDialogCellEditor(getViewer().getTable()),COL_GRAPH);
		
//		autoSizeOnContents = new boolean[]{true, true, true, true, true, true, true, true};
		autoSizeOnContents = new boolean[]{true, false, true, true, true, true, true, true};
//		columnExpands = new boolean[]{false, true, false, false, false, false, false, false};
				
//		enforceMinWidths = new boolean[]{false, false, true, true, true, true, true, true};
		
		configure();

		for (int i = 0; i < datas.size(); i++) {
			try {
				GraphElement ge = (GraphElement)datas.get(i);
				if (ge != null) ge.dispose();	
			} catch (Throwable e) {}
		}

		datas = new Vector();
		for (int i = 0; i < values.length; i++)
			datas.add(new GraphElement((Graph)values[i][0], (String)values[i][1], (String)values[i][2], (RGB)values[i][3], (Integer)values[i][4], (Integer)values[i][5], (Integer)values[i][6], (Integer)values[i][7], values[i][8], values[i][9] ));

		getViewer().getTable().addFocusListener(this);
		getViewer().getTable().addSelectionListener(this);
	}

	public void ensureGraphsValid() {

		for (int i = 0; i < datas.size(); i++) {
			GraphElement element = (GraphElement)datas.get(i);

			if (element.xslider.intValue() >= sliderXChoices.length) {
				element.xslider = new Integer(0);	
			}

			if (element.yslider.intValue() >= sliderYChoices.length) {
				element.yslider = new Integer(0);	
			}
		}

		try {
			getViewer().refresh(true);
		} catch (Exception e) {}
//		if (tableViewer != null) tableViewer.refresh(true);
	}

	public String [] getComboChoices(Object element, int columnIndex)
	{
		if (columnIndex == COL_STYLE) {
			return styleChoicesString;
		} else if (columnIndex == COL_WIDTH) {
			return widthChoicesString;
		} else if (columnIndex == COL_XSLIDER) {
			return sliderXChoicesString;
		} else if (columnIndex == COL_YSLIDER) {
			return sliderYChoicesString;
		}
			
		return new String[0];
	}
	
	public void setXSliderChoices(Integer[] values, String[] names) {
		sliderXChoices = values;
		sliderXChoicesString = names;

//		comboBoxSliderXCellEditor.setItems(names);

		ensureGraphsValid();
		
		redraw();
	}
	
	public void setYSliderChoices(Integer[] values, String[] names) {
		sliderYChoices = values;
		sliderYChoicesString = names;

//		comboBoxSliderYCellEditor.setItems(names);

		ensureGraphsValid();

		redraw();
	}

	public void setValues(Object[][] values)
	{

		for (int i = 0; i < datas.size(); i++) {
			try {
				GraphElement ge = (GraphElement)datas.get(i);
				if (ge != null) ge.dispose();	
			} catch (Throwable e) {}
		}

		datas.clear();
		for (int i = 0; i < values.length; i++)
			datas.add(new GraphElement((Graph)values[i][0], (String)values[i][1], (String)values[i][2], (RGB)values[i][3], (Integer)values[i][4], (Integer)values[i][5], (Integer)values[i][6], (Integer)values[i][7], values[i][8], values[i][9] ));

//		tableViewer.setInput(datas);
		configure();
	}


	public Object[][] getValues()
	{
		Object[][] result = new Object[datas.size()][10];
		for (int v = 0; v < datas.size(); v++)
		{
			result[v][0] = ((GraphElement) datas.get(v)).graph;
			result[v][1] = ((GraphElement) datas.get(v)).name;
			result[v][2] = ((GraphElement) datas.get(v)).description;
			result[v][3] = ((GraphElement) datas.get(v)).color;
			result[v][4] = ((GraphElement) datas.get(v)).line_width;
			result[v][5] = ((GraphElement) datas.get(v)).line_style;
			result[v][6] = ((GraphElement) datas.get(v)).xslider;
			result[v][7] = ((GraphElement) datas.get(v)).yslider;
			result[v][8] = ((GraphElement) datas.get(v)).scaling;
			result[v][9] = ((GraphElement) datas.get(v)).descriptor;
		}
		return result;
	}


	public void dispose() {
		super.dispose();
		
		disposables.addAll(datas);
		
		for (int i = 0; i < disposables.size(); i++) {
			try {
			Object o = disposables.get(i);
			if (o != null) {
				if (o instanceof Widget) {
					((Widget)o).dispose();	
				} else if (o instanceof Color) {
					((Color)o).dispose();	
				} else if (o instanceof Image) {
					((Image)o).dispose();	
				} else {
					try {
						EditorPlugin.disposeObject(o);
					} catch (Throwable e) {
						EditorPlugin.DBG.warning("Class not found when disposing of "+o.getClass()+"/"+o+" ("+e+")");
					}
				}
			}
			} catch (Throwable e) {
				EditorPlugin.DBG.error("Problem disposing of objects",e);
			}
		}		
	}
	
	public void valueChanged(Object element, int column, String newValue) throws InvalidTableValueException {
/*		
		if (column == COL_SCALING) {
			try {
				valueChanged(element,column,new Double(newValue));
			} catch (NumberFormatException e) {
				throw new InvalidTableValueException("invalid number format");
			}
		}
*/		
	}
	
	public void valueChanged(Object element, int column, Float newValue) throws InvalidTableValueException {
		valueChanged(element,column,new Double(newValue.doubleValue()));
	}
	
	public void valueChanged(Object element, int column, Double newValue) throws InvalidTableValueException {
/*		
		double val = newValue.doubleValue();

		GraphElement e = (GraphElement)element;

		boolean changed = false;

		if (column == COL_SCALING) {
			changed = true;
			e.scaling = new Double(val);
			
		}
		
		if (changed) {
			notifyListeners(e.graph);
			getViewer().refresh(e);
		}
*/		
	}

	public void valueChanged(Object element, int column, Boolean newValue) throws InvalidTableValueException {
	}
		
	public void valueChanged(Object element, int column, RGB value) throws InvalidTableValueException {
		GraphElement e = (GraphElement)element;
		
		boolean changed = false;

		if (column == COL_RGB) {
			if(!value.equals(e.color))
			{
				changed = true;
				e.color = (RGB)value;
				e.update();
			}
		}
			
		if (changed) {
			notifyListenersEdit(e.graph);
			getViewer().refresh(e);
		}
	}

	public void valueChanged(Object element, int column, Integer newValue) throws InvalidTableValueException {
		int val = newValue.intValue();
		
		GraphElement e = (GraphElement)element;
		
		boolean changed = false;
		
		if (column == COL_WIDTH) {
			changed = true;
			e.line_width = widthChoices[val];
			
		} else if (column == COL_STYLE) {
			changed = true;
			e.line_style = styleChoices[val];
			
		} else if (column == COL_XSLIDER) {
			changed = true;
			e.xslider = sliderXChoices[val];
			
		} else if (column == COL_YSLIDER) {
			changed = true;
			e.yslider = sliderYChoices[val];
			
/*		} else if (column == COL_SCALING) {
			changed = true;
			e.scaling = new Double(val);
*/			
		}

		if (changed) {
			notifyListenersEdit(e.graph);
			getViewer().refresh(e);
		}
	
	}

	public void valueChanged(Object element, int column) throws InvalidTableValueException {
		((GraphElement)element).readFromGraph();
		configure();
		getViewer().refresh(element);
//		getViewer().update(element, null);
	}
ArrayList disposables = new ArrayList();
	public class GraphElement
	{
		public Graph graph;
		public String name;
		public String description;
		public Integer line_width;
		public Integer line_style;
		public Integer xslider;
		public Integer yslider;
		public RGB color;
		public Object scaling;
		public Object descriptor;
		
		RGB black_rgb;

		Image image;
		GC image_gc;
//		Color bg_col, fg_col;

		public void readFromGraph() {
			line_width = new Integer(graph.getLineWidth());
			line_style = new Integer(graph.getLineStyle());
			xslider = (Integer)lookup(sliderXChoicesString,sliderXChoices,graph.getXSlider().getTitle());
			yslider = (Integer)lookup(sliderYChoicesString,sliderYChoices,graph.getYSlider().getTitle());
//			scaling = new Double(graph.getStaticScaling());
			color = graph.getForeground().getRGB();
			redrawImage();
		}
		
		public GraphElement(Graph graph, String name, String description, RGB color, Integer line_width, Integer line_style, Integer x_slider, Integer y_slider, Object scaling, Object descriptor)
		{
			this.graph = graph;
			this.name = name;
			this.description = description;
			this.line_width = line_width;
			this.line_style = line_style;
			this.xslider = x_slider;
			this.yslider = y_slider;
			this.color = color;
			this.scaling = scaling;
			this.descriptor = descriptor;

			black_rgb = new RGB(0,0,0);

			PaletteData palettedat = new PaletteData(new RGB[]{color,color});
			ImageData imgdat = new ImageData(11,11,1,palettedat);			
			image = new Image(getDisplay(),imgdat);

/*
			Image tmpimage = image;
			Color tmpcol = fg_col;

			image = new Image(getDisplay(),16,16);
			image_gc = new GC(image);
			image_gc.setBackground(graph_bg.getBackground());
			image_gc.fillRectangle(0,0,16,16);
			
			fg_col = new Color(getDisplay(),color);
			image_gc.setForeground(fg_col);
			image_gc.setLineStyle(graph.getLineStyle());
			image_gc.setLineWidth(graph.getLineWidth());
			image_gc.drawLine(0,7,16,7);
*/

			redrawImage();
		}

		public void update() {
			redrawImage();
		}
		
		public void redrawImage() {
/*
			Image tmpimage = image;
			Color tmpcol = fg_col;
			GC tmpgc = image_gc;

			image = new Image(getDisplay(),16,16);
			image_gc = new GC(image);
			image_gc.setBackground(graph..getBackground());
			image_gc.fillRectangle(0,0,16,16);
			
			fg_col = new Color(getDisplay(),color);
			image_gc.setForeground(fg_col);
			image_gc.setLineStyle(graph.getLineStyle());
			image_gc.setLineWidth(graph.getLineWidth());
			image_gc.drawLine(0,7,16,7);

			tmpcol.dispose();
			tmpimage.dispose();
			tmpgc.dispose();
*/

			PaletteData palettedat = new PaletteData(new RGB[]{color,color});
			ImageData imgdat = new ImageData(11,11,1,palettedat);			
			Image tmpimage = image;

			image = new Image(getDisplay(),imgdat);
			
			tmpimage.dispose();

		}
		
		public void dispose() {
			image.dispose();	
		}
	}

	private Object lookup(Object[] indexer, Object[] result, Object o) {
//		int index = Arrays.binarySearch(indexer,o);
		for (int i = 0; i < indexer.length; i++) {
			if (indexer[i].equals(o)) {
				return result[i];
			}
		}
		return result[-1];
	}
	
	public String getColumnText(Object element, int columnIndex)
	{
		GraphElement el = (GraphElement) element;
		
		if (columnIndex == COL_NAME) {
			return el.name;	
		} else if (columnIndex == COL_DESC) {
			return el.description;
		} else if (columnIndex == COL_RGB) {
			return "";
		} else if (columnIndex == COL_WIDTH) {
			return ""+lookup(widthChoices,widthChoicesString,el.line_width);
		} else if (columnIndex == COL_STYLE) {
			return ""+lookup(styleChoices,styleChoicesString,el.line_style);
		} else if (columnIndex == COL_XSLIDER) {
			return ""+lookup(sliderXChoices,sliderXChoicesString,el.xslider);
		} else if (columnIndex == COL_YSLIDER) {
			return ""+lookup(sliderYChoices,sliderYChoicesString,el.yslider);
		} else if (columnIndex == COL_GRAPH) {
			return EditorPlugin.getString("TABLE_COLUMN_ADVANCED");		
//		} else if (columnIndex == COL_SCALING) {
//			return ""+el.scaling;
		}
		
		return "";
	}
	
	public Image getColumnImage(Object element, int columnIndex)
	{
		GraphElement el = (GraphElement) element;
	
		if (columnIndex == COL_RGB) {
			return el.image;
		} else {
			return null;	
		}
	}
	
	public RGB getColumnRGB(Object element, int columnIndex)
	{
		GraphElement el = (GraphElement) element;
	
		if (columnIndex == COL_RGB) {
			return el.color;
		} else {
			return null;	
		}
	}
	
boolean has_focus = false;		
	public Graph getSelectedGraph() {
		if (!has_focus) return null;
		int n = getViewer().getTable().getSelectionIndex();
		if (n == -1) return null;
		GraphElement element = (GraphElement)datas.get(n);
		return element.graph;
	}	

	public void redrawGraphs() {
		graph_control.redraw();	
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		redrawGraphs();
		Graph g = getSelectedGraph();
		if (g != null) {
			notifyListenersSelect(g);
		}
	}
	public void focusLost(FocusEvent e) {
		has_focus = false;
		redrawGraphs();
	}
	public void focusGained(FocusEvent e) {
		has_focus = true;
		redrawGraphs();
	}

}