/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.editor.internal;

import org.eclipse.hyades.model.statistical.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.emf.common.util.*;

import java.util.*;

public class ObservationMerger extends Thread {
	
SDContiguousObservation target;	
BasicEList target_values;
BasicEList target_times;
ArrayList sources;

ArrayList sizes = new ArrayList();

	public ObservationMerger(ArrayList sources, SDMemberDescriptor des) {
		
		target = StatisticalFactory.eINSTANCE.createSDContiguousObservation();
		target.setMemberDescriptor(des);
		target.setWindow(((SDSnapshotObservation)sources.get(0)).getWindow());
		
		this.sources = sources;
		
		setDaemon(true);
		start();
	}
	public ObservationMerger(ArrayList sources, SDContiguousObservation target) {
		this.target = target;
		this.sources = sources;

		setDaemon(true);
		start();
	}
	
	public void run() {
		
		for (int i = 0; i < sources.size(); i++) {
			Object o = sources.get(i);
			if (o instanceof SDContiguousObservation) {
				SDContiguousObservation obs = (SDContiguousObservation)o;
				sizes.add(new Integer(0));
//				sizes.add(new Integer(obs.getValue().size()));
			} else if (o instanceof SDDiscreteObservation) {
				SDDiscreteObservation obs = (SDDiscreteObservation)o;
				sizes.add(new Integer(0));
//				sizes.add(new Integer(obs.getValue().size()));
			} else {
				EditorPlugin.DBG.error("ObservationMerger got an observation that wasnt contigious or discrete ("+o.getClass()+")");
				//error
				return;
			}
		}
		
		target_values = (BasicEList)target.getValue();
		target_times = (BasicEList)target.getCreationTime();
		
		while (true) {
			for (int i = 0; i < sources.size(); i++) {
				Object o = sources.get(i);
				int size = ((Integer)sizes.get(i)).intValue();
				
				if (o instanceof SDContiguousObservation) {
					SDContiguousObservation obs = (SDContiguousObservation)o;
					EList values = obs.getValue();
					EList times = obs.getCreationTime();
					int vsize = values.size();
					
					if (vsize != size) {
						//changed, add the new data points
						for (int k = size; k < vsize; k++) {
							addData((Double)values.get(k),(Double)times.get(k));
						}
						
						sizes.set(i,new Integer(values.size()));
					}
					
//					sizes.add(new Integer(obs.getValue().size()));
				} else if (o instanceof SDDiscreteObservation) {
					SDDiscreteObservation obs = (SDDiscreteObservation)o;
//					sizes.add(new Integer(obs.getValue().size()));

					EList values = obs.getValue();
					EList times = obs.getCreationTime();
					int vsize = values.size();
					
					if (vsize != size) {
						//changed, add the new data points
						for (int k = size; k < vsize; k++) {
							addData(new Double(((Integer)values.get(k)).doubleValue()),(Double)times.get(k));
						}
						
						sizes.set(i,new Integer(values.size()));
					}
				}
			}

			//dont soak cpu
			
			try {
				Thread.sleep(500);
			} catch (Exception e) {}
			
			
		}
	}

	private void addData(Double d, Double l) {
		//search backwards for the correct timestamp
		double tnew = l.doubleValue();
		double tcurr = Double.MAX_VALUE;
		int i = target_times.size();
//may be -1 ^^^^^
		while (tcurr > tnew && i > 0) {
			i--;
			tcurr = ((Double)target_times.get(i)).doubleValue();
		}
		
//		if (tcurr == tnew) System.out.println("EXACTLY EQUAL TIMESTAMPS!");
//		tnew-=0.1;
		
		if (i < 0) i = 0;
		
		//insert at i
		if (i != target_times.size()) {
			i++;
			target_times.addUnique(i,l);
			target_values.addUnique(i,d);
		} else {
			target_times.addUnique(l);
			target_values.addUnique(d);
		}
if (target_times.size() != target_values.size()) System.err.println("DIFFERENT SIZE BETWEEN TIME AND VALUES");		
		
//		for (i = 0; i < target_times.size(); i++) {
//System.err.println(i+" "+(((Double)target_times.get(i)).doubleValue()%1000000));			
//		}
	}

}