/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.logfile;

import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.hyades.model.statistical.*;

import java.io.*;
import java.text.*;
import java.util.*;

public class LogFileAlertAction implements AlertAction {

boolean trigger;
String name;
double value;
double time;

String path = "StatConAlerts.log";
static SimpleDateFormat sdf = new SimpleDateFormat();

	public AlertActionControl getControl(Composite c) {
		return new LogFileControl(c,this);
	}
	
	public String getDescription() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_LOGFILE")+" ("+path+")";
	}
	
	public String getProviderName() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_LOGFILE");
	}
	public void setInformation(String name, SDSnapshotObservation obs, double value, double time, boolean trigger) {
		this.name = name;
		this.value = value;
		this.time = time;
		this.trigger = trigger;
	}
	public void run() {
		try {
			FileOutputStream fout = new FileOutputStream(path,true);
			PrintStream pout = new PrintStream(fout);
			Date d = new Date((long)time);
			if (trigger) {
				pout.println(sdf.format(d)+": "+name+" triggered at "+value);
			} else {
				pout.println(sdf.format(d)+": "+name+" reset at "+value);
			}
			pout.flush();
			fout.close();
		
		} catch (IOException e) {
			EditorPlugin.DBG.warning("error logging alert to file "+e);
		}
	}
	public Object clone() {
		LogFileAlertAction action = new LogFileAlertAction();
		action.name = name;
		action.value = value;
		action.time = time;
		action.trigger = trigger;
		action.path = path;
		return action;
	}
}

