/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.monitoractions.internal.sound;

import org.eclipse.hyades.statistical.ui.widgets.alert.internal.*;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.hyades.statistical.ui.editor.internal.*;
import org.eclipse.hyades.statistical.ui.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.*;

public class SoundControl extends AlertActionControl implements SelectionListener {
SoundAlertAction action;

Label label;
Text path;
Button browse;

	public SoundControl(Composite c, SoundAlertAction action) {
		super(c,0);
		this.action = action;
		
		initGraphics();
		initEventHandling();
		
		readFromAction(action);
	}
	
	private void initGraphics() {
		setLayout(new GridLayout(2,false));
		
		label = new Label(this,0);
		label.setText(EditorPlugin.getString("ALERT_ACTION_SOUND_PATH"));
		label.setLayoutData(GData.getGridData(true,false,-1,-1,2,1,GridData.FILL,GridData.FILL));
		
		path = new Text(this,SWT.BORDER);
		path.setText("              ");
		path.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.FILL));
		
		browse = new Button(this,0);
		browse.setText(EditorPlugin.getString("BROWSE"));
		browse.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.FILL,GridData.END));
	}
	
	private void initEventHandling() {
		browse.addSelectionListener(this);
	}
	
	public void readFromAction(AlertAction tmp) {
		SoundAlertAction lfaction = (SoundAlertAction)tmp;
		path.setText(lfaction.path);
	}
	
	public void writeToAction(AlertAction tmp) throws InvalidDataException {
		if (path.getText().length() == 0) {
			throw new InvalidDataException(EditorPlugin.getString("ERROR_EMPTY_ALERT_SOUND_PATH"));
		}
		SoundAlertAction lfaction = (SoundAlertAction)tmp;
		lfaction.path = path.getText();
	}
	public AlertAction writeToClonedAction() throws InvalidDataException {
		SoundAlertAction clone = (SoundAlertAction)action.clone();
		writeToAction(clone);
		return clone;
	}
	public AlertAction writeToOriginalAction() throws InvalidDataException {
		writeToAction(action);
		return action;
	}

	public String getDescription() {
		return EditorPlugin.getString("ALERT_ACTION_NAME_SOUND");
	}
	
	////////////////////////
	// selection listener
	///////////////////////
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	public void widgetSelected(SelectionEvent e) {
		widgetSelected(e.getSource());
	}
	public void widgetSelected(Object o) {
		if (o == browse) {
			FileDialog fd = new FileDialog(getShell());
			fd.setFileName(path.getText());
			String tmp = fd.open();
			
			if (tmp != null) {
				if (tmp.length() != 0) {
					path.setText(tmp);
				}
			}
			
		}
	}
	
}

