/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

public interface BasicGraphSource {
	
	public static final double POSITIVE_INFINITY = Double.POSITIVE_INFINITY;
	public static final double NEGATIVE_INFINITY = Double.NEGATIVE_INFINITY;
	
	/**
	 * Get the minimum time this graph has data at
	 * @return the minimum time this graph has data at
	 */
	public double getMin();

	/**
	 * Get the maximum time this graph has data at
	 * @return the maximum time this graph has data at
	 */
	public double getMax();

}