/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.grapher.internal;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

public class GraphCanvas extends Canvas implements PaintListener {

ArrayList graphs = new ArrayList();

private static final boolean PAINT_BUFFERED = true;
int buffer_w = -1;
int buffer_h = -1;
Image buffer = null;
GC buffer_gc = null;

int xoffset, yoffset;

Color bgcol;

GraphHighlighter highlighter = null;
GraphSelectionSource selection_source = null;

	public GraphCanvas(Composite parent, int style) {
		super(parent,style|SWT.NO_BACKGROUND);
		addPaintListener(this);

		setBackground(getDisplay().getSystemColor(SWT.COLOR_LIST_BACKGROUND));
	}
	
	public void addGraph(Graph graph) {
		graphs.add(graph);
	}
	
	public void removeGraph(Graph graph) {
		graphs.remove(graph);
	}
	
	public void removeAllGraphs() {
		graphs.clear();	
	}
	
	public void dispose() {
		super.dispose();
		if (buffer != null) {
			buffer.dispose();
			buffer_gc.dispose();	
			if (bgcol != null) bgcol.dispose();
		}	
	}
	
	public void setBackground(RGB rgb) {
		if (bgcol != null) bgcol.dispose();
		bgcol = new Color(getDisplay(),rgb);
		super.setBackground(bgcol);	
	}
	
	public void setGraphHighlighter(GraphHighlighter h) {
		highlighter = h;
	}
	
	public void setGraphSelectionSource(GraphSelectionSource source) {
		selection_source = source;	
	}

	public void calculateOffsets() {
		for (int i = 0; i < graphs.size(); i++) {
			Graph g = (Graph)graphs.get(i);
			Control yslider = g.getYSlider();
			Control xslider = g.getXSlider();
			if (yslider != null && xslider != null) {
				yoffset = yslider.getBounds().y;
				xoffset = xslider.getBounds().x;
				return;
			}
		}
	}
	
	
	//////////////////////////////
	// PAINT LISTENER
	//////////////////////////////
	
	public void paintControl(PaintEvent e) {
		GC gc = e.gc;
		int x = e.x;
		int y = e.y;
		int w = e.width;
		int h = e.height;

		if (w < 1 || h < 1) return;

		if (PAINT_BUFFERED) {
//			PaletteData pd = new PaletteData(0,0,0);
//			ImageData idat = new ImageData(w,h,?,pd);
			
//			if (buffer == null) {
//				buffer = new Image(gc,idat);
//			}

			if ((buffer_w < w || buffer_h < h) && buffer != null) {
				buffer.dispose();
				buffer_gc.dispose();
				buffer = null;
				buffer_gc = null;
			}

			if (buffer == null) {
				if (getDisplay() == null) return; 
				buffer_w = Math.max(buffer_w,w);
				buffer_h = Math.max(buffer_h,h);
				buffer = new Image(getDisplay(),buffer_w,buffer_h);
				buffer_gc = new GC(buffer); 	
			}
			
			paintUnbuffered(buffer_gc,0,0,w,h);
//			paintUnbuffered(buffer_gc,x,y,w,h);

			gc.drawImage(buffer,0,0);
			
		} else {
			paintUnbuffered(gc,x,y,w,h);
		}
	}

	public void paintUnbuffered(GC gc, int x, int y, int w, int h) {
		
		Graph highlighted = null;
		if (highlighter != null && selection_source != null) {
			highlighted = selection_source.getSelectedGraph();	
		}

		//calculate the offsets so we match up with the sliders.
		calculateOffsets();

		//draw background
		Color c = getBackground();
		//note fillRectangle uses BACKGROUND colour
		gc.setBackground(c);
		gc.fillRectangle(x,y,w+xoffset,h+yoffset);
//		gc.fillRectangle(x,y,w,h);
		gc.fillRectangle(0,0,10000,10000);
		
		int textoffset = 0;
		
		//draw graphs
		for (int i = 0; i < graphs.size(); i++) {
			
			Graph g = (Graph)graphs.get(i);
			
			if (g == highlighted) {
				highlighter.setHighlight(g);	
			}

			if (g instanceof TextGraph) {
				textoffset = ((TextGraph)g).paintGraph(gc,x+xoffset,y+yoffset,w,h,textoffset);
			} else {			
				g.paintGraph(gc,x+xoffset,y+yoffset,w,h);
			}	

			if (g == highlighted) {
				highlighter.unsetHighlight(g);	
			}
		}
	}

}