/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.edit.datapool;

/**
 * This class defines the base interface for all named elements.  Each named
 * element has a standard set of associated properties.  Any undefined property
 * will return <code>null</code> for the property value.
 * 
 * @see	IDatapool
 * @see IDatapoolEquivalenceClass
 * @see	IDatapoolVariable
 */
public interface INamedElement extends
	org.eclipse.hyades.execution.runtime.datapool.INamedElement
{
	
	/**
	 * Specify the GUID for the associated element.
	 * 
	 * @see #getId()
	 */
	public void setId(String id);
	
	/**
	 * Specify the name for the associated element.
	 * 
	 * @see #getName()
	 */
	public void setName(String name);
	
	/**
	 * Specify the description for the associated element.
	 * 
	 * @see	#getDescription()
	 */
	public void setDescription(String description);
	
}
