/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.execution.runtime.datapool;

/**
 * @author ahoppe
 *
 * Interface to be implemented by datapool iterator extensions
 * Assumptions: 1.Datapool iterator implementations are split into base and extending class
 *                (this is the interface of extending class)
 *              2.The extending class has to maintain the data members of the base class.
 *              3.The extending class has to have static getInstance() factory method
 *                instead of public constructor
 *                
 */
public interface IDatapoolIteratorExt {
				/**
				 * Initialize the iterator sequence from the specified datapool object.
				 * Depending on the implementation of this method the iterator may use
				 * sequential or random access order, share a cursor with other processes
				 * or use a repeating sequence to access the records.  The order of access
				 * is left to the individual iterator implementations.
				 * 
				 * @param	datapool	The datapool to iterate over.
				 * @param	equivalenceClassIndex	The zero-based index of the equivalence
				 *						class that should be iterated over.  If this value
				 *						is negative then all records in the datapool should be
				 *						will be available to the iterator.
				 */
			    public void dpInitialize(IDatapool datapool, int equivalenceClassIndex);
	
				/**
				 * This method acts the same way as {@link #dpInitialize(IDatapool,int) dpInitialize with equivalence class specification}
				 * except that {@link IDatapool#getDefaultEquivalenceClassIndex() default} 
				 * equivalence class is used.
				 * 
				 * @param	datapool	The datapool to iterate over.
				 */
				public void dpInitialize(IDatapool datapool);



				/**
				 * Returns <code>true</code> if the {@link #dpCurrent() current} iterator
				 * value is <code>null</code>.
				 * 
				 * @see	#dpCurrent()
				 * @see #dpNext()
				 * @see #dpReset()
				 */
				public boolean dpDone();

	
				/**
				 * Increments the iterator associated with an instance of the datapool.
				 * Calling this method after the iteration sequence has been exhausted has no
				 * effect.
				 * 
				 * @see	#dpCurrent()
				 * @see #dpDone()
				 * @see #dpReset()
				 */
				public void dpNext();

	
				/**
				 * Restart the iterator associated with an instance of the datapool.
				 * It does not matter if the iterator has been exhausted of entries or
				 * not, the iterator simply resets to the initial start state.
				 * 
				 * @see	#dpCurrent()
				 * @see #dpDone()
				 * @see #dpNext()
				 */
				public void dpReset();

}
