/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.statistical;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentLoadersFactory;

/**
 * @author slavescu
 */
public class StatisticalXMLLoadersFactory
	implements XMLFragmentLoadersFactory {
	//~ Methods
	// ------------------------------------------------------------------------------------

	protected static final String Descriptor = "Descriptor";
	protected static final String SampleDescriptor = "SampleDescriptor";
	protected static final String CounterDescriptor = "CounterDescriptor";
	protected static final String DiscreteObservation = "DiscreteObservation";
	protected static final String ContiguousObservation = "ContiguousObservation";
	protected static final String TextObservation = "TextObservation";

	public String getLoaderClassName(String elementName) {
		switch (LoadersUtils.getHashCode(elementName)) {
			case StatisticalConstants.Descriptor_int :
				return XMLDescriptorLoader.class.getName();
			case StatisticalConstants.SampleDescriptor_int :
				return XMLSampleDescriptorLoader.class.getName();
			case StatisticalConstants.CounterDescriptor_int :
				return XMLCounterDescriptorLoader.class.getName();
			case StatisticalConstants.DiscreteObservation_int:
				return XMLDiscreteObservationLoader.class.getName();
			case StatisticalConstants.ContiguousObservation_int :
				return XMLContiguousObservationLoader.class.getName();
			case StatisticalConstants.TextObservation_int :
				return XMLTextObservationLoader.class.getName();
			default :
				return null;
		}
	}

	public Set getSupportedElements() {
		Set set = new HashSet();

		set.add(Descriptor);
		set.add(SampleDescriptor);
		set.add(CounterDescriptor);
		set.add(DiscreteObservation);
		set.add(ContiguousObservation);
		set.add(TextObservation);
		
		return set;
	}
}
