/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.model.statistical;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Internal package, please do not extend or use.
 * This package is intended to describe structured and dynamically typed statistical data.
 * <!-- end-model-doc -->
 * @see org.eclipse.hyades.model.statistical.StatisticalFactory
 * @generated
 */
public interface StatisticalPackage extends EPackage{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "statistical";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/statistical.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Statistical";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	StatisticalPackage eINSTANCE = org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl <em>SD Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDDescriptorImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDDescriptor()
	 * @generated
	 */
	int SD_DESCRIPTOR = 0;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DESCRIPTOR__AGENT = HierarchyPackage.ABSTRACT_TRC_DESCRIPTION__AGENT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DESCRIPTOR__ID = HierarchyPackage.ABSTRACT_TRC_DESCRIPTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DESCRIPTOR__NAME = HierarchyPackage.ABSTRACT_TRC_DESCRIPTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DESCRIPTOR__DESCRIPTION = HierarchyPackage.ABSTRACT_TRC_DESCRIPTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DESCRIPTOR__CHILDREN = HierarchyPackage.ABSTRACT_TRC_DESCRIPTION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DESCRIPTOR__PARENT = HierarchyPackage.ABSTRACT_TRC_DESCRIPTION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the the '<em>SD Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DESCRIPTOR_FEATURE_COUNT = HierarchyPackage.ABSTRACT_TRC_DESCRIPTION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDMemberDescriptorImpl <em>SD Member Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDMemberDescriptorImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDMemberDescriptor()
	 * @generated
	 */
	int SD_MEMBER_DESCRIPTOR = 1;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__AGENT = SD_DESCRIPTOR__AGENT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__ID = SD_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__NAME = SD_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__DESCRIPTION = SD_DESCRIPTOR__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__CHILDREN = SD_DESCRIPTOR__CHILDREN;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__PARENT = SD_DESCRIPTOR__PARENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__REPRESENTATION = SD_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Snapshot Observation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION = SD_DESCRIPTOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>SD Member Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_MEMBER_DESCRIPTOR_FEATURE_COUNT = SD_DESCRIPTOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDRepresentationImpl <em>SD Representation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDRepresentationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDRepresentation()
	 * @generated
	 */
	int SD_REPRESENTATION = 12;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_REPRESENTATION__MEMBER_DESCRIPTOR = 0;

	/**
	 * The number of structural features of the the '<em>SD Representation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_REPRESENTATION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDDiscreteRepresentationImpl <em>SD Discrete Representation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDDiscreteRepresentationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDDiscreteRepresentation()
	 * @generated
	 */
	int SD_DISCRETE_REPRESENTATION = 14;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_REPRESENTATION__MEMBER_DESCRIPTOR = SD_REPRESENTATION__MEMBER_DESCRIPTOR;

	/**
	 * The number of structural features of the the '<em>SD Discrete Representation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_REPRESENTATION_FEATURE_COUNT = SD_REPRESENTATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDRangeRepresentationImpl <em>SD Range Representation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDRangeRepresentationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDRangeRepresentation()
	 * @generated
	 */
	int SD_RANGE_REPRESENTATION = 10;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_RANGE_REPRESENTATION__MEMBER_DESCRIPTOR = SD_DISCRETE_REPRESENTATION__MEMBER_DESCRIPTOR;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_RANGE_REPRESENTATION__MIN = SD_DISCRETE_REPRESENTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_RANGE_REPRESENTATION__MAX = SD_DISCRETE_REPRESENTATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>SD Range Representation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_RANGE_REPRESENTATION_FEATURE_COUNT = SD_DISCRETE_REPRESENTATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDGaugeRepresentationImpl <em>SD Gauge Representation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDGaugeRepresentationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDGaugeRepresentation()
	 * @generated
	 */
	int SD_GAUGE_REPRESENTATION = 2;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_GAUGE_REPRESENTATION__MEMBER_DESCRIPTOR = SD_RANGE_REPRESENTATION__MEMBER_DESCRIPTOR;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_GAUGE_REPRESENTATION__MIN = SD_RANGE_REPRESENTATION__MIN;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_GAUGE_REPRESENTATION__MAX = SD_RANGE_REPRESENTATION__MAX;

	/**
	 * The feature id for the '<em><b>Max Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_GAUGE_REPRESENTATION__MAX_THRESHOLD = SD_RANGE_REPRESENTATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Min Threshold</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_GAUGE_REPRESENTATION__MIN_THRESHOLD = SD_RANGE_REPRESENTATION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>SD Gauge Representation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_GAUGE_REPRESENTATION_FEATURE_COUNT = SD_RANGE_REPRESENTATION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDSampleDescriptorImpl <em>SD Sample Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDSampleDescriptorImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDSampleDescriptor()
	 * @generated
	 */
	int SD_SAMPLE_DESCRIPTOR = 3;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__AGENT = SD_MEMBER_DESCRIPTOR__AGENT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__ID = SD_MEMBER_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__NAME = SD_MEMBER_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__DESCRIPTION = SD_MEMBER_DESCRIPTOR__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__CHILDREN = SD_MEMBER_DESCRIPTOR__CHILDREN;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__PARENT = SD_MEMBER_DESCRIPTOR__PARENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__REPRESENTATION = SD_MEMBER_DESCRIPTOR__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Snapshot Observation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__SNAPSHOT_OBSERVATION = SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION;

	/**
	 * The feature id for the '<em><b>Update Frequencey</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR__UPDATE_FREQUENCEY = SD_MEMBER_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>SD Sample Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_DESCRIPTOR_FEATURE_COUNT = SD_MEMBER_DESCRIPTOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDViewImpl <em>SD View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDViewImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDView()
	 * @generated
	 */
	int SD_VIEW = 4;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_VIEW__AGENT = HierarchyPackage.ABSTRACT_TRC_VIEW__AGENT;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_VIEW__NAME = HierarchyPackage.ABSTRACT_TRC_VIEW_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Window</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_VIEW__WINDOW = HierarchyPackage.ABSTRACT_TRC_VIEW_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the the '<em>SD View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_VIEW_FEATURE_COUNT = HierarchyPackage.ABSTRACT_TRC_VIEW_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDSampleWindowImpl <em>SD Sample Window</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDSampleWindowImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDSampleWindow()
	 * @generated
	 */
	int SD_SAMPLE_WINDOW = 5;

	/**
	 * The feature id for the '<em><b>View</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_WINDOW__VIEW = 0;

	/**
	 * The feature id for the '<em><b>Observations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_WINDOW__OBSERVATIONS = 1;

	/**
	 * The number of structural features of the the '<em>SD Sample Window</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SAMPLE_WINDOW_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDSnapshotObservationImpl <em>SD Snapshot Observation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDSnapshotObservationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDSnapshotObservation()
	 * @generated
	 */
	int SD_SNAPSHOT_OBSERVATION = 6;

	/**
	 * The feature id for the '<em><b>Validity Mask</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK = 0;

	/**
	 * The feature id for the '<em><b>Creation Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SNAPSHOT_OBSERVATION__CREATION_TIME = 1;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR = 2;

	/**
	 * The feature id for the '<em><b>Window</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SNAPSHOT_OBSERVATION__WINDOW = 3;

	/**
	 * The number of structural features of the the '<em>SD Snapshot Observation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_SNAPSHOT_OBSERVATION_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDDiscreteObservationImpl <em>SD Discrete Observation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDDiscreteObservationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDDiscreteObservation()
	 * @generated
	 */
	int SD_DISCRETE_OBSERVATION = 7;

	/**
	 * The feature id for the '<em><b>Validity Mask</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_OBSERVATION__VALIDITY_MASK = SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK;

	/**
	 * The feature id for the '<em><b>Creation Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_OBSERVATION__CREATION_TIME = SD_SNAPSHOT_OBSERVATION__CREATION_TIME;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_OBSERVATION__MEMBER_DESCRIPTOR = SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR;

	/**
	 * The feature id for the '<em><b>Window</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_OBSERVATION__WINDOW = SD_SNAPSHOT_OBSERVATION__WINDOW;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_OBSERVATION__VALUE = SD_SNAPSHOT_OBSERVATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>SD Discrete Observation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_DISCRETE_OBSERVATION_FEATURE_COUNT = SD_SNAPSHOT_OBSERVATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDContiguousObservationImpl <em>SD Contiguous Observation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDContiguousObservationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDContiguousObservation()
	 * @generated
	 */
	int SD_CONTIGUOUS_OBSERVATION = 8;

	/**
	 * The feature id for the '<em><b>Validity Mask</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_OBSERVATION__VALIDITY_MASK = SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK;

	/**
	 * The feature id for the '<em><b>Creation Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_OBSERVATION__CREATION_TIME = SD_SNAPSHOT_OBSERVATION__CREATION_TIME;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_OBSERVATION__MEMBER_DESCRIPTOR = SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR;

	/**
	 * The feature id for the '<em><b>Window</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_OBSERVATION__WINDOW = SD_SNAPSHOT_OBSERVATION__WINDOW;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_OBSERVATION__VALUE = SD_SNAPSHOT_OBSERVATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>SD Contiguous Observation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_OBSERVATION_FEATURE_COUNT = SD_SNAPSHOT_OBSERVATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDTextObservationImpl <em>SD Text Observation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDTextObservationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDTextObservation()
	 * @generated
	 */
	int SD_TEXT_OBSERVATION = 9;

	/**
	 * The feature id for the '<em><b>Validity Mask</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_OBSERVATION__VALIDITY_MASK = SD_SNAPSHOT_OBSERVATION__VALIDITY_MASK;

	/**
	 * The feature id for the '<em><b>Creation Time</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_OBSERVATION__CREATION_TIME = SD_SNAPSHOT_OBSERVATION__CREATION_TIME;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_OBSERVATION__MEMBER_DESCRIPTOR = SD_SNAPSHOT_OBSERVATION__MEMBER_DESCRIPTOR;

	/**
	 * The feature id for the '<em><b>Window</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_OBSERVATION__WINDOW = SD_SNAPSHOT_OBSERVATION__WINDOW;

	/**
	 * The feature id for the '<em><b>Text Value</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_OBSERVATION__TEXT_VALUE = SD_SNAPSHOT_OBSERVATION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the the '<em>SD Text Observation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_OBSERVATION_FEATURE_COUNT = SD_SNAPSHOT_OBSERVATION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDCounterDescriptorImpl <em>SD Counter Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDCounterDescriptorImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDCounterDescriptor()
	 * @generated
	 */
	int SD_COUNTER_DESCRIPTOR = 11;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__AGENT = SD_MEMBER_DESCRIPTOR__AGENT;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__ID = SD_MEMBER_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__NAME = SD_MEMBER_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__DESCRIPTION = SD_MEMBER_DESCRIPTOR__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Children</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__CHILDREN = SD_MEMBER_DESCRIPTOR__CHILDREN;

	/**
	 * The feature id for the '<em><b>Parent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__PARENT = SD_MEMBER_DESCRIPTOR__PARENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__REPRESENTATION = SD_MEMBER_DESCRIPTOR__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Snapshot Observation</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR__SNAPSHOT_OBSERVATION = SD_MEMBER_DESCRIPTOR__SNAPSHOT_OBSERVATION;

	/**
	 * The number of structural features of the the '<em>SD Counter Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_COUNTER_DESCRIPTOR_FEATURE_COUNT = SD_MEMBER_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDTextRepresentationImpl <em>SD Text Representation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDTextRepresentationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDTextRepresentation()
	 * @generated
	 */
	int SD_TEXT_REPRESENTATION = 13;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_REPRESENTATION__MEMBER_DESCRIPTOR = SD_REPRESENTATION__MEMBER_DESCRIPTOR;

	/**
	 * The number of structural features of the the '<em>SD Text Representation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_TEXT_REPRESENTATION_FEATURE_COUNT = SD_REPRESENTATION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.model.statistical.impl.SDContiguousRepresentationImpl <em>SD Contiguous Representation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.model.statistical.impl.SDContiguousRepresentationImpl
	 * @see org.eclipse.hyades.model.statistical.impl.StatisticalPackageImpl#getSDContiguousRepresentation()
	 * @generated
	 */
	int SD_CONTIGUOUS_REPRESENTATION = 15;

	/**
	 * The feature id for the '<em><b>Member Descriptor</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_REPRESENTATION__MEMBER_DESCRIPTOR = SD_REPRESENTATION__MEMBER_DESCRIPTOR;

	/**
	 * The number of structural features of the the '<em>SD Contiguous Representation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SD_CONTIGUOUS_REPRESENTATION_FEATURE_COUNT = SD_REPRESENTATION_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDDescriptor <em>SD Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Descriptor</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor
	 * @generated
	 */
	EClass getSDDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor#getId()
	 * @see #getSDDescriptor()
	 * @generated
	 */
	EAttribute getSDDescriptor_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor#getDescription()
	 * @see #getSDDescriptor()
	 * @generated
	 */
	EAttribute getSDDescriptor_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor#getName()
	 * @see #getSDDescriptor()
	 * @generated
	 */
	EAttribute getSDDescriptor_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getChildren <em>Children</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Children</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor#getChildren()
	 * @see #getSDDescriptor()
	 * @generated
	 */
	EReference getSDDescriptor_Children();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.model.statistical.SDDescriptor#getParent <em>Parent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Parent</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDescriptor#getParent()
	 * @see #getSDDescriptor()
	 * @generated
	 */
	EReference getSDDescriptor_Parent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDMemberDescriptor <em>SD Member Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Member Descriptor</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDMemberDescriptor
	 * @generated
	 */
	EClass getSDMemberDescriptor();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.model.statistical.SDMemberDescriptor#getRepresentation <em>Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Representation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDMemberDescriptor#getRepresentation()
	 * @see #getSDMemberDescriptor()
	 * @generated
	 */
	EReference getSDMemberDescriptor_Representation();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.model.statistical.SDMemberDescriptor#getSnapshotObservation <em>Snapshot Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Snapshot Observation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDMemberDescriptor#getSnapshotObservation()
	 * @see #getSDMemberDescriptor()
	 * @generated
	 */
	EReference getSDMemberDescriptor_SnapshotObservation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDGaugeRepresentation <em>SD Gauge Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Gauge Representation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDGaugeRepresentation
	 * @generated
	 */
	EClass getSDGaugeRepresentation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDGaugeRepresentation#getMaxThreshold <em>Max Threshold</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max Threshold</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDGaugeRepresentation#getMaxThreshold()
	 * @see #getSDGaugeRepresentation()
	 * @generated
	 */
	EAttribute getSDGaugeRepresentation_MaxThreshold();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDGaugeRepresentation#getMinThreshold <em>Min Threshold</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min Threshold</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDGaugeRepresentation#getMinThreshold()
	 * @see #getSDGaugeRepresentation()
	 * @generated
	 */
	EAttribute getSDGaugeRepresentation_MinThreshold();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDSampleDescriptor <em>SD Sample Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Sample Descriptor</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSampleDescriptor
	 * @generated
	 */
	EClass getSDSampleDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDSampleDescriptor#getUpdateFrequencey <em>Update Frequencey</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Update Frequencey</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSampleDescriptor#getUpdateFrequencey()
	 * @see #getSDSampleDescriptor()
	 * @generated
	 */
	EAttribute getSDSampleDescriptor_UpdateFrequencey();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDView <em>SD View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD View</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDView
	 * @generated
	 */
	EClass getSDView();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDView#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDView#getName()
	 * @see #getSDView()
	 * @generated
	 */
	EAttribute getSDView_Name();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.model.statistical.SDView#getWindow <em>Window</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Window</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDView#getWindow()
	 * @see #getSDView()
	 * @generated
	 */
	EReference getSDView_Window();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDSampleWindow <em>SD Sample Window</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Sample Window</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSampleWindow
	 * @generated
	 */
	EClass getSDSampleWindow();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.model.statistical.SDSampleWindow#getView <em>View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>View</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSampleWindow#getView()
	 * @see #getSDSampleWindow()
	 * @generated
	 */
	EReference getSDSampleWindow_View();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.model.statistical.SDSampleWindow#getObservations <em>Observations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Observations</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSampleWindow#getObservations()
	 * @see #getSDSampleWindow()
	 * @generated
	 */
	EReference getSDSampleWindow_Observations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDSnapshotObservation <em>SD Snapshot Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Snapshot Observation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSnapshotObservation
	 * @generated
	 */
	EClass getSDSnapshotObservation();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.model.statistical.SDSnapshotObservation#getValidityMask <em>Validity Mask</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Validity Mask</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSnapshotObservation#getValidityMask()
	 * @see #getSDSnapshotObservation()
	 * @generated
	 */
	EAttribute getSDSnapshotObservation_ValidityMask();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.model.statistical.SDSnapshotObservation#getCreationTime <em>Creation Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Creation Time</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSnapshotObservation#getCreationTime()
	 * @see #getSDSnapshotObservation()
	 * @generated
	 */
	EAttribute getSDSnapshotObservation_CreationTime();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.model.statistical.SDSnapshotObservation#getMemberDescriptor <em>Member Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Member Descriptor</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSnapshotObservation#getMemberDescriptor()
	 * @see #getSDSnapshotObservation()
	 * @generated
	 */
	EReference getSDSnapshotObservation_MemberDescriptor();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.model.statistical.SDSnapshotObservation#getWindow <em>Window</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Window</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDSnapshotObservation#getWindow()
	 * @see #getSDSnapshotObservation()
	 * @generated
	 */
	EReference getSDSnapshotObservation_Window();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDDiscreteObservation <em>SD Discrete Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Discrete Observation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDiscreteObservation
	 * @generated
	 */
	EClass getSDDiscreteObservation();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.model.statistical.SDDiscreteObservation#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Value</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDiscreteObservation#getValue()
	 * @see #getSDDiscreteObservation()
	 * @generated
	 */
	EAttribute getSDDiscreteObservation_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDContiguousObservation <em>SD Contiguous Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Contiguous Observation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDContiguousObservation
	 * @generated
	 */
	EClass getSDContiguousObservation();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.model.statistical.SDContiguousObservation#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Value</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDContiguousObservation#getValue()
	 * @see #getSDContiguousObservation()
	 * @generated
	 */
	EAttribute getSDContiguousObservation_Value();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDTextObservation <em>SD Text Observation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Text Observation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDTextObservation
	 * @generated
	 */
	EClass getSDTextObservation();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.hyades.model.statistical.SDTextObservation#getTextValue <em>Text Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Text Value</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDTextObservation#getTextValue()
	 * @see #getSDTextObservation()
	 * @generated
	 */
	EAttribute getSDTextObservation_TextValue();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDRangeRepresentation <em>SD Range Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Range Representation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDRangeRepresentation
	 * @generated
	 */
	EClass getSDRangeRepresentation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDRangeRepresentation#getMin <em>Min</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Min</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDRangeRepresentation#getMin()
	 * @see #getSDRangeRepresentation()
	 * @generated
	 */
	EAttribute getSDRangeRepresentation_Min();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.model.statistical.SDRangeRepresentation#getMax <em>Max</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Max</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDRangeRepresentation#getMax()
	 * @see #getSDRangeRepresentation()
	 * @generated
	 */
	EAttribute getSDRangeRepresentation_Max();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDCounterDescriptor <em>SD Counter Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Counter Descriptor</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDCounterDescriptor
	 * @generated
	 */
	EClass getSDCounterDescriptor();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDRepresentation <em>SD Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Representation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDRepresentation
	 * @generated
	 */
	EClass getSDRepresentation();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.model.statistical.SDRepresentation#getMemberDescriptor <em>Member Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Member Descriptor</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDRepresentation#getMemberDescriptor()
	 * @see #getSDRepresentation()
	 * @generated
	 */
	EReference getSDRepresentation_MemberDescriptor();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDTextRepresentation <em>SD Text Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Text Representation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDTextRepresentation
	 * @generated
	 */
	EClass getSDTextRepresentation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDDiscreteRepresentation <em>SD Discrete Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Discrete Representation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDDiscreteRepresentation
	 * @generated
	 */
	EClass getSDDiscreteRepresentation();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.model.statistical.SDContiguousRepresentation <em>SD Contiguous Representation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SD Contiguous Representation</em>'.
	 * @see org.eclipse.hyades.model.statistical.SDContiguousRepresentation
	 * @generated
	 */
	EClass getSDContiguousRepresentation();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	StatisticalFactory getStatisticalFactory();

} //StatisticalPackage
