package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author Scott Brown
 * @author Andrea
 * @version 1.0.1
 * @since 1.0.1
 */
public class AssociatedEventImplTest extends TestCase {
    /**
     * Target instances for all fixtures 
     */
    private AssociatedEvent ase;

    public AssociatedEventImplTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ase = EventFactory.eINSTANCE.createAssociatedEvent();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAssociatedEventImpl() {
    }

    /*
     * Test for EClass eStaticClass()
     */
    public void testEStaticClass() {
    }

    public void testGetAssociationEngine() {
        String outStr = ase.getAssociationEngine();
        assertNull(outStr);
    }

    public void testSetAssociationEngine() {
        String inStr = "set_association_engine";
        String outStr = null;

        ase.setAssociationEngine(inStr);
        outStr = ase.getAssociationEngine();
        assertEquals(inStr, outStr);

        ase.setAssociationEngine(null);
        outStr = ase.getAssociationEngine();
        assertNull(outStr);
    }

    public void testGetResolvedEvents() {
        String inStr = "1234567812345678 8765432187654321 1234123412341234";
        String outStr = null;

        outStr = ase.getResolvedEvents();
        assertNull(outStr);

        ase.setResolvedEvents(inStr);
        outStr = ase.getResolvedEvents();
        assertEquals(inStr, outStr);

        ase.setResolvedEvents(null);
        outStr = ase.getResolvedEvents();
        assertNull(outStr);
    }

    public void testGetResolvedEventsAsArray() {
        String inStr = "1234567812345678 8765432187654321 1234123412341234";
        String[] outArray = null;

        outArray = ase.getResolvedEventsAsArray();
        assertEquals(0, outArray.length);

        ase.setResolvedEvents(inStr);
        outArray = ase.getResolvedEventsAsArray();
        assertEquals(3, outArray.length);
        assertEquals("1234567812345678", outArray[0]);
        assertEquals("8765432187654321", outArray[1]);
        assertEquals("1234123412341234", outArray[2]);

        ase.setResolvedEvents(null);
        outArray = ase.getResolvedEventsAsArray();
        assertEquals(0, outArray.length);
    }

    public void testSetResolvedEvents() {
        String inStr = "1234567812345678 8765432187654321 1234123412341234";
        String outStr = null;

        ase.setResolvedEvents(inStr);
        outStr = ase.getResolvedEvents();
        assertEquals(inStr, outStr);

        ase.setResolvedEvents(null);
        outStr = ase.getResolvedEvents();
        assertNull(outStr);
    }

    public void testSetResolvedEventsAsArray() {
        String[] inStr = { "1234567812345678", "8765432187654321", "1234123412341234" };
        String[] inNullStr = new String[0];
        String[] inBadStr = { "1234567812345678", "87654321 7654321", "1234123412341234" };
        String outStr = null;
        String[] outArray;

        ase.setResolvedEventsAsArray(inStr);
        outStr = ase.getResolvedEvents();
        assertNotNull(outStr);
        assertEquals("1234567812345678 8765432187654321 1234123412341234", outStr);

        ase.setResolvedEventsAsArray(inNullStr);
        outArray = ase.getResolvedEventsAsArray();
        assertEquals(0, outArray.length);
        outStr = ase.getResolvedEvents();
        assertEquals(0, outStr.length());

        try {
            ase.setResolvedEventsAsArray(inBadStr);
            fail("passed in an array that contains a blank in one element");
        }
        catch (IllegalArgumentException ex) {
        }

        try {
            ase.setResolvedEventsAsArray(null);
            fail("passed in null rather than null array");
        }
        catch (IllegalArgumentException ex) {
        }
    }

    public void testGetAssociationEngineInfo() {
        AssociationEngine myase;
        String inStr1 = "myName";
        String inStr2 = "myType";
        String inStr3 = "myId";

        myase = ase.getAssociationEngineInfo();
        assertNull("testGetAssociationEngineInfo()", myase);

        ase.setAssociationEngineInfo(inStr1, inStr2, inStr3);
        myase = ase.getAssociationEngineInfo();
        assertEquals(inStr1, myase.getName());
        assertEquals(inStr2, myase.getType());
        assertEquals(inStr3, myase.getId());

        ase.setAssociationEngineInfo(null, null, null);
        myase = ase.getAssociationEngineInfo();
        assertNotNull(myase);
        assertNull(myase.getName());
        assertNull(myase.getType());
        assertNull(myase.getId());
    }

    public void testBasicSetAssociationEngineInfo() {
        /*
         * generated code, tested by testSetAssociationEngineInfoAssociationEngine() - testBasicSetAssociationEngineInfo()
         */
    }

    /*
     * Test for void setAssociationEngineInfo(AssociationEngine)
     */
    public void testSetAssociationEngineInfoAssociationEngine() {
        AssociationEngine myase;
        String inStr1 = "myName";
        String inStr2 = "myType";
        String inStr3 = "myId";

        ase.setAssociationEngineInfo(inStr1, inStr2, inStr3);
        AssociationEngine myase1 = ase.getAssociationEngineInfo();
        assertEquals(inStr1, myase1.getName());
        assertEquals(inStr2, myase1.getType());
        assertEquals(inStr3, myase1.getId());

        ase.setAssociationEngineInfo("xxx", "yyy", "zzz");
        AssociationEngine myase2 = ase.getAssociationEngineInfo();
        assertEquals("xxx", myase2.getName());
        assertEquals("yyy", myase2.getType());
        assertEquals("zzz", myase2.getId());

        ase.setAssociationEngineInfo(myase1);
        AssociationEngine myase3 = ase.getAssociationEngineInfo();
        assertEquals(inStr1, myase3.getName());
        assertEquals(inStr2, myase3.getType());
        assertEquals(inStr3, myase3.getId());
    }

    /*
     * Test for NotificationChain eInverseRemove(InternalEObject, int, Class, NotificationChain)
     */
    public void testEInverseRemoveInternalEObjectintClassNotificationChain() {
        /*
         * generated code, no need to test - testEInverseRemoveInternalEObjectintClassNotificationChain()
         */
    }

    /*
     * Test for Object eGet(EStructuralFeature, boolean)
     */
    public void testEGetEStructuralFeatureboolean() {
        /*
         * generated code, no need to test - testEGetEStructuralFeatureboolean()
         */
    }

    /*
     * Test for void eSet(EStructuralFeature, Object)
     */
    public void testESetEStructuralFeatureObject() {
        /*
         * generated code, no need to test - testESetEStructuralFeatureObject()
         */
    }

    /*
     * Test for void eUnset(EStructuralFeature)
     */
    public void testEUnsetEStructuralFeature() {
        /*
         * generated code, no need to test - testEUnsetEStructuralFeature()
         */
    }

    /*
     * Test for boolean eIsSet(EStructuralFeature)
     */
    public void testEIsSetEStructuralFeature() {
        /*
         * generated code, no need to test - testEIsSetEStructuralFeature()
         */
    }

    /*
     * Test for String toString()
     */
    public void testToString() {
        assertNotNull("empty AssociatedEvent", ase.toString());

        ase = EventFactory.eINSTANCE.createAssociatedEvent();
        AssociationEngine myEngineInfo = EventFactory.eINSTANCE.createAssociationEngine();
        myEngineInfo.setId("myId");
        myEngineInfo.setName("myName");
        myEngineInfo.setType("myValue");
        
        ase.setAssociationEngineInfo(myEngineInfo);

        ase.setAssociationEngine("my associationEngine");
        ase.setResolvedEvents(Util.getAlphaString(35) + " " + Util.getAlphaString(50));
        assertNotNull("Associated Event with some data filled in", ase.toString());
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals1() throws ValidationException {
        String gid1 = "AE123456789012345678901234567890";
        String gid2 = "BE123456789012345678901234567890";
        String gid3 = "CE123456789012345678901234567890";
        String[] inStr1 = { gid1, gid2 };
        String[] inStr2 = { gid2, gid3 };

        AssociatedEvent ae1 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae1.setAssociationEngine(Util.getAlphaString(32));
        ae1.setResolvedEventsAsArray(inStr1);

        AssociatedEvent ae2 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae2.setAssociationEngine(Util.getAlphaString(32));
        ae2.setResolvedEventsAsArray(inStr2);

        ae1.validate();
        ae2.validate();

        AssociatedEvent ae3 = (AssociatedEvent) Util.clone(ae1);
        assertEquals(ae1, ae3);

        AssociatedEvent ae4 = (AssociatedEvent) Util.clone(ae2);
        assertEquals(ae2, ae4);

        assertFalse(ae1.equals(ae2));
    }

    public void testEquals2() throws ValidationException {
        String gid1 = "AE123456789012345678901234567890";
        String gid2 = "BE123456789012345678901234567890";
        String gid3 = "CE123456789012345678901234567890";
        String[] inStr1 = { gid1, gid2 };

        AssociatedEvent ae1 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae1.setResolvedEventsAsArray(inStr1);
        AssociationEngine eng1 = EventFactory.eINSTANCE.createAssociationEngine();
        eng1.setName("engine test");
        eng1.setType("Type");
        eng1.setId("AE345678901234567890123456789012");
        ae1.setAssociationEngineInfo(eng1);

        AssociatedEvent ae2 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae2.setResolvedEventsAsArray(inStr1);
        AssociationEngine eng2 = EventFactory.eINSTANCE.createAssociationEngine();
        eng2.setName("engine test");
        eng2.setType("Type");
        eng2.setId("BE345678901234567890123456789012");
        ae2.setAssociationEngineInfo(eng2);

        ae1.validate();
        ae2.validate();

        AssociatedEvent ae3 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae3.setResolvedEventsAsArray(inStr1);
        AssociationEngine eng3 = EventFactory.eINSTANCE.createAssociationEngine();
        eng3.setName("engine test");
        eng3.setType("Type");
        eng3.setId("AE345678901234567890123456789012");
        ae3.setAssociationEngineInfo(eng3);
        assertEquals(ae1, ae3);

        AssociatedEvent ae4 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae4.setResolvedEventsAsArray(inStr1);
        AssociationEngine eng4 = EventFactory.eINSTANCE.createAssociationEngine();
        eng4.setName("engine test");
        eng4.setType("Type");
        eng4.setId("BE345678901234567890123456789012");
        ae4.setAssociationEngineInfo(eng4);
        assertEquals(ae2, ae4);

        assertFalse(ae1.equals(ae2));
    }

    public void testEquals3() throws ValidationException {
        String gid1 = "AE123456789012345678901234567890";
        String gid2 = "BE123456789012345678901234567890";
        String[] inStr1 = { gid1, gid2 };

        AssociatedEvent ae1 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae1.setResolvedEventsAsArray(inStr1);
        AssociationEngine eng1 = EventFactory.eINSTANCE.createAssociationEngine();
        eng1.setName("engine test");
        eng1.setType("Type");
        eng1.setId("AE345678901234567890123456789012");
        ae1.setAssociationEngineInfo(eng1);

        ae1.validate();

        AssociatedEvent ae2 = EventFactory.eINSTANCE.createAssociatedEvent();
        ae2.setResolvedEventsAsArray(inStr1);
        ;

        /**
         * ae2.setAssociationEngineInfo(eng1); -> does not work
         * need to create a new AssociationEngine object to be assigned to ae2,  
         * because EMF does not support a single object with multiple parents.
         */
        AssociationEngine eng2 = EventFactory.eINSTANCE.createAssociationEngine();
        eng2.setName("engine test");
        eng2.setType("Type");
        eng2.setId("AE345678901234567890123456789012");
        ae2.setAssociationEngineInfo(eng2);

        ae1.validate();
        ae2.validate();

        assertEquals(ae1, ae2);
    }

    public void testValidate() throws ValidationException {
        Util.assertMissingAttributes(ase, "all");

        ase.setResolvedEvents("EDE test");

        try {
            ase.validate();
            fail("missing mutually exclusive attributes in " + ase.getClass().getName());
        }
        catch (ValidationException ve) {
            Util.assertExceptionId("IWAT0204E", ve);
        }

        ase.setAssociationEngine("cid");
        try {
            ase.validate();
            fail("invalid resolvedEvents for " + ase.getClass().getName());
        }
        catch (ValidationException ve) {
            Util.assertExceptionId("IWAT0206E", ve);
        }

        ase.setResolvedEvents(Util.getAlphaString(32) + " " + Util.getAlphaString(64));
        try {
            ase.validate();
            fail("invalid id for " + ase.getClass().getName());
        }
        catch (ValidationException ve) {
            Util.assertExceptionId("IWAT0208E", ve);
        }

        ase.setAssociationEngine(Util.getAlphaString(32));
        ase.validate();
    }

    public void testValidate2() throws ValidationException {
        Util.assertMissingAttributes(ase, "this is an empty associatedEvent");

        ase.setResolvedEvents(Util.getAlphaString(32));

        try {
            ase.validate();
            fail("missing mutually exclusive attributes in " + ase.getClass().getName());
        }
        catch (ValidationException ve) {
            Util.assertExceptionId("IWAT0204E", ve);
        }

        ase = EventFactory.eINSTANCE.createAssociatedEvent();

        AssociationEngine aei = EventFactory.eINSTANCE.createAssociationEngine();
        aei.setName("AEI name");
        aei.setType("AEI type");
        aei.setId(Util.getAlphaString(32));
        ase.setAssociationEngineInfo(aei);
        Util.assertMissingAttributes(ase, "resolvedEvents");

        ase.setResolvedEvents(Util.getAlphaString(32) + " " + Util.getAlphaString(64));
        ase.validate();
    }

    /*
     * Test for void setAssociationEngineInfo(String, String, String)
     */
    public void testSetAssociationEngineInfoStringStringString() {
        AssociationEngine myase;
        String inStr1 = "myName";
        String inStr2 = "myType";
        String inStr3 = "myId";

        ase.setAssociationEngineInfo(inStr1, inStr2, inStr3);
        myase = ase.getAssociationEngineInfo();
        assertEquals(inStr1, myase.getName());
        assertEquals(inStr2, myase.getType());
        assertEquals(inStr3, myase.getId());

        ase.setAssociationEngineInfo(null, null, null);
        myase = ase.getAssociationEngineInfo();
        assertNotNull(myase);
        assertNull(myase.getName());
        assertNull(myase.getType());
        assertNull(myase.getId());
    }

}
