package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.FeatureSituation;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit test case for the <code>FeatureSituationImpl</code> class.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 */
public class FeatureSituationImplTest extends TestCase {

    /** Target instance for the tests. */
    private FeatureSituation sit;

    /**
     * Constructor for FeatureSituationImplTest.
     * @param testcase
     */
    public FeatureSituationImplTest(String testcase) {
        super(testcase);
    }

    /**
     * Tests whether <code>toString</code> doesn't blow up.
     */
    public void testToString() {
        assertNotNull(sit.toString());
    }

    /**
     * Tests presence of attributes in the public interface
     */
    public void testInterface() {
        sit.getFeatureDisposition();
        sit.getReasoningScope();
        // setters show on other tests

        assertTrue(sit instanceof SituationType);
    }

    /**
     * Tests the serialization for <code>FeatureSituation</code>.
     */
    public void testSerialization() {
        Util.testEObjectSerialization(sit);
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals() {
        FeatureSituation sit2 = (FeatureSituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit.setFeatureDisposition("f");
        sit.setReasoningScope("r");
        sit2 = (FeatureSituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit2.setFeatureDisposition("difference");
        assertFalse(sit.equals(sit2));
    }

    /**
     * Tests validation for <code>FeatureSituation</code>.
     */
    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(sit, "all");

        sit.setFeatureDisposition("f");
        sit.setReasoningScope("r");
        sit.validate();

        sit.setFeatureDisposition(null);
        Util.assertMissingAttributes(sit, "featureDisposition");

        sit.setFeatureDisposition("f");
        sit.setReasoningScope(null);
        Util.assertMissingAttributes(sit, "reasoningScope");
    }

    /**
     * Tests validation for <code>FeatureSituation</code>.
     */
    public void testValidationInvalidLengths() {
        sit.setFeatureDisposition(Util.getPaddedString(64));
        sit.setReasoningScope(Util.getPaddedString(64));
        try {
            sit.validate();
        }
        catch (ValidationException e) {
            fail("Strings have correct length");
        }

        sit.setFeatureDisposition(Util.getPaddedString(65));
        sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(sit, "featureDisposition");

        sit.setFeatureDisposition(Util.getPaddedString(64));
        sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(sit, "reasoningScope");
    }

    /**
     * 
     */
    public void testAdapter() {
        Util.assertAdapterNotification(sit);
    }

    /**
     * 
     */
    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(sit);
    }

    /*
     * Protected methods.
     */

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eFx = EventFactory.eINSTANCE;
        sit = eFx.createFeatureSituation();
    }

}
