package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * JUnit test case for the <code>MsgCatalogToken</code> class.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 */
public class MsgCatalogTokenImplTest extends TestCase {

    /** Target instance for the tests. */
    private MsgCatalogToken mct;

    /**
     * Constructor for MsgCatalogTokenImplTest.
     * @param testcase
     */
    public MsgCatalogTokenImplTest(String testcase) {
        super(testcase);
    }

    /**
     * Tests presence of attributes in the public interface
     */
    public void testInterface() {
        mct.getValue();
        // setters show on other tests
    }

    /**
     * Tests the serialization for <code>RequestSituation</code>.
     */
    public void testSerialization() {
        Util.testEObjectSerialization(mct);
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals() {
        MsgCatalogToken mct2 = (MsgCatalogToken) Util.clone(mct);
        assertEquals(mct, mct2);

        mct2.setValue("difference");
        assertFalse(mct.equals(mct2));
    }

    /**
     * Tests whether <code>toString</code> doesn't blow up.
     */
    public void testToString() {
        assertNotNull(mct.toString());
    }

    /**
     * Tests validation for <code>StopSituation</code>.
     */
    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(mct, "all");

        mct.setValue("value");
        mct.validate();

        mct.setValue(null);
        Util.assertMissingAttributes(mct, "value");
    }

    /**
     * Tests validation for <code>StopSituation</code>.
     */
    public void testValidationInvalidLengths() {
        mct.setValue(Util.getPaddedString(256));
        Util.assertValidBoundaries(mct);

        mct.setValue(Util.getPaddedString(257));
        Util.assertInvalidBoundaries(mct, "value");
    }

    /*
     * Protected methods.
     */

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eFx = EventFactory.eINSTANCE;
        mct = eFx.createMsgCatalogToken();
    }

}