package org.eclipse.hyades.logging.events.cbe.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.FormattingException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 *
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 */
public class FormattingExceptionTest extends TestCase {
   
    /**
     * Constructor for FormattingExceptionTest.
     * @param arg0
     */
    public FormattingExceptionTest(String arg0) {
        super(arg0);
    }

    /*
     * Test for void FormattingException()
     */
    public void testFormattingException() {
        new FormattingException();
    }

    /*
     * Test for void FormattingException(String)
     */
    public void testFormattingExceptionString() {
        String msg = "test";
        FormattingException e = new FormattingException(msg);
        assertEquals(msg, e.getMessage());
    }

    /*
     * Test for void FormattingException(String, String)
     */
    public void testFormattingExceptionStringString() {
        
        FormattingException e = new FormattingException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_"));

        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", null);
    }

    /*
     * Test for void FormattingException(String, String, Object[])
     */
    public void testFormattingExceptionStringStringObjectArray() {

        FormattingException e = new FormattingException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_","a"));
        
        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
    }

    /*
     * Test for void FormattingException(String, String, Object[], Throwable)
     */
    public void testFormattingExceptionStringStringObjectArrayThrowable() {

        Exception linkedException = new Exception();

        FormattingException e = new FormattingException(EventHelpers.getString("LOG_INVALID_JNDI_REFERENCE_EXC_", "a"), linkedException);
        
        EventExceptionTest.assertExceptionMsg(e, "LOG_INVALID_JNDI_REFERENCE_EXC_", new Object[] { "a" });
        
        assertEquals(linkedException, e.getCause());
    }
}
