/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CorrelationQueryImpl.java,v 1.7 2004/11/29 21:08:05 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.extensions.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.extensions.CorrelationQuery;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Query</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl#getCorrelationContainerURI <em>Correlation Container URI</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.extensions.impl.CorrelationQueryImpl#getDeltaTime <em>Delta Time</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class CorrelationQueryImpl extends SimpleSearchQueryImpl implements CorrelationQuery {
	/**
	 * The default value of the '{@link #getCorrelationContainerURI() <em>Correlation Container URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainerURI()
	 * @generated
	 * @ordered
	 */
	protected static final String CORRELATION_CONTAINER_URI_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCorrelationContainerURI() <em>Correlation Container URI</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainerURI()
	 * @generated
	 * @ordered
	 */
	protected String correlationContainerURI = CORRELATION_CONTAINER_URI_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDeltaTime() <em>Delta Time</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeltaTime()
	 * @generated
	 * @ordered
	 */
	protected EList deltaTime = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationQueryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ExtensionsPackage.eINSTANCE.getCorrelationQuery();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getCorrelationContainerURI() {
		return correlationContainerURI;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCorrelationContainerURI(String newCorrelationContainerURI) {
		String oldCorrelationContainerURI = correlationContainerURI;
		correlationContainerURI = newCorrelationContainerURI;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI, oldCorrelationContainerURI, correlationContainerURI));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDeltaTime() {
		if (deltaTime == null) {
			deltaTime = new EDataTypeUniqueEList(Double.class, this, ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME);
		}
		return deltaTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.CORRELATION_QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicAdd(otherEnd, msgs);
				case ExtensionsPackage.CORRELATION_QUERY__ORDER_BY_EXPRESIONS:
					return ((InternalEList)getOrderByExpresions()).basicAdd(otherEnd, msgs);
				case ExtensionsPackage.CORRELATION_QUERY__WHERE_EXPRESSIONS:
					return ((InternalEList)getWhereExpressions()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ExtensionsPackage.CORRELATION_QUERY__OUTPUT_ELEMENTS:
					return ((InternalEList)getOutputElements()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.CORRELATION_QUERY__SUB_QUERY:
					return ((InternalEList)getSubQuery()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.CORRELATION_QUERY__ORDER_BY_EXPRESIONS:
					return ((InternalEList)getOrderByExpresions()).basicRemove(otherEnd, msgs);
				case ExtensionsPackage.CORRELATION_QUERY__WHERE_EXPRESSIONS:
					return ((InternalEList)getWhereExpressions()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.CORRELATION_QUERY__NAME:
				return getName();
			case ExtensionsPackage.CORRELATION_QUERY__SOURCES:
				return getSources();
			case ExtensionsPackage.CORRELATION_QUERY__DISTINCT:
				return isDistinct() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.CORRELATION_QUERY__COUNT:
				return isCount() ? Boolean.TRUE : Boolean.FALSE;
			case ExtensionsPackage.CORRELATION_QUERY__OUTPUT_ELEMENTS:
				return getOutputElements();
			case ExtensionsPackage.CORRELATION_QUERY__SUB_QUERY:
				return getSubQuery();
			case ExtensionsPackage.CORRELATION_QUERY__MAX_ELEMENTS:
				return new Integer(getMaxElements());
			case ExtensionsPackage.CORRELATION_QUERY__ORDER_BY_EXPRESIONS:
				return getOrderByExpresions();
			case ExtensionsPackage.CORRELATION_QUERY__WHERE_EXPRESSIONS:
				return getWhereExpressions();
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				return getCorrelationContainerURI();
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				return getDeltaTime();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.CORRELATION_QUERY__NAME:
				setName((String)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__SOURCES:
				getSources().clear();
				getSources().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__DISTINCT:
				setDistinct(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.CORRELATION_QUERY__COUNT:
				setCount(((Boolean)newValue).booleanValue());
				return;
			case ExtensionsPackage.CORRELATION_QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				getOutputElements().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__SUB_QUERY:
				getSubQuery().clear();
				getSubQuery().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__MAX_ELEMENTS:
				setMaxElements(((Integer)newValue).intValue());
				return;
			case ExtensionsPackage.CORRELATION_QUERY__ORDER_BY_EXPRESIONS:
				getOrderByExpresions().clear();
				getOrderByExpresions().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__WHERE_EXPRESSIONS:
				getWhereExpressions().clear();
				getWhereExpressions().addAll((Collection)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				setCorrelationContainerURI((String)newValue);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				getDeltaTime().clear();
				getDeltaTime().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.CORRELATION_QUERY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__SOURCES:
				getSources().clear();
				return;
			case ExtensionsPackage.CORRELATION_QUERY__DISTINCT:
				setDistinct(DISTINCT_EDEFAULT);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__COUNT:
				setCount(COUNT_EDEFAULT);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__OUTPUT_ELEMENTS:
				getOutputElements().clear();
				return;
			case ExtensionsPackage.CORRELATION_QUERY__SUB_QUERY:
				getSubQuery().clear();
				return;
			case ExtensionsPackage.CORRELATION_QUERY__MAX_ELEMENTS:
				setMaxElements(MAX_ELEMENTS_EDEFAULT);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__ORDER_BY_EXPRESIONS:
				getOrderByExpresions().clear();
				return;
			case ExtensionsPackage.CORRELATION_QUERY__WHERE_EXPRESSIONS:
				getWhereExpressions().clear();
				return;
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				setCorrelationContainerURI(CORRELATION_CONTAINER_URI_EDEFAULT);
				return;
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				getDeltaTime().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ExtensionsPackage.CORRELATION_QUERY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ExtensionsPackage.CORRELATION_QUERY__SOURCES:
				return sources != null && !sources.isEmpty();
			case ExtensionsPackage.CORRELATION_QUERY__DISTINCT:
				return distinct != DISTINCT_EDEFAULT;
			case ExtensionsPackage.CORRELATION_QUERY__COUNT:
				return count != COUNT_EDEFAULT;
			case ExtensionsPackage.CORRELATION_QUERY__OUTPUT_ELEMENTS:
				return outputElements != null && !outputElements.isEmpty();
			case ExtensionsPackage.CORRELATION_QUERY__SUB_QUERY:
				return subQuery != null && !subQuery.isEmpty();
			case ExtensionsPackage.CORRELATION_QUERY__MAX_ELEMENTS:
				return maxElements != MAX_ELEMENTS_EDEFAULT;
			case ExtensionsPackage.CORRELATION_QUERY__ORDER_BY_EXPRESIONS:
				return orderByExpresions != null && !orderByExpresions.isEmpty();
			case ExtensionsPackage.CORRELATION_QUERY__WHERE_EXPRESSIONS:
				return whereExpressions != null && !whereExpressions.isEmpty();
			case ExtensionsPackage.CORRELATION_QUERY__CORRELATION_CONTAINER_URI:
				return CORRELATION_CONTAINER_URI_EDEFAULT == null ? correlationContainerURI != null : !CORRELATION_CONTAINER_URI_EDEFAULT.equals(correlationContainerURI);
			case ExtensionsPackage.CORRELATION_QUERY__DELTA_TIME:
				return deltaTime != null && !deltaTime.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (correlationContainerURI: ");
		result.append(correlationContainerURI);
		result.append(", deltaTime: ");
		result.append(deltaTime);
		result.append(')');
		return result.toString();
	}

} //CorrelationQueryImpl
