/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: CorrelationContainerProxyImpl.java,v 1.9 2004/11/29 21:08:05 slavescu Exp $
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.CorrelationContainer;
import org.eclipse.hyades.models.hierarchy.CorrelationContainerProxy;
import org.eclipse.hyades.models.hierarchy.CorrelationEngine;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Correlation Container Proxy</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCreationTime <em>Creation Time</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCorrelationContainer <em>Correlation Container</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCorrelatedAgents <em>Correlated Agents</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getCorrelationEngine <em>Correlation Engine</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationContainerProxyImpl#getMonitor <em>Monitor</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CorrelationContainerProxyImpl extends EObjectImpl  implements CorrelationContainerProxy {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreationTime()
	 * @generated
	 * @ordered
	 */
	protected static final long CREATION_TIME_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getCreationTime() <em>Creation Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreationTime()
	 * @generated
	 * @ordered
	 */
	protected long creationTime = CREATION_TIME_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCorrelationContainer() <em>Correlation Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationContainer()
	 * @generated
	 * @ordered
	 */
	protected CorrelationContainer correlationContainer = null;

	/**
	 * The cached value of the '{@link #getCorrelatedAgents() <em>Correlated Agents</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelatedAgents()
	 * @generated
	 * @ordered
	 */
	protected EList correlatedAgents = null;

	/**
	 * The cached value of the '{@link #getCorrelationEngine() <em>Correlation Engine</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCorrelationEngine()
	 * @generated
	 * @ordered
	 */
	protected CorrelationEngine correlationEngine = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CorrelationContainerProxyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getCorrelationContainerProxy();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public long getCreationTime() {
		return creationTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCreationTime(long newCreationTime) {
		long oldCreationTime = creationTime;
		creationTime = newCreationTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME, oldCreationTime, creationTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainer getCorrelationContainer() {
		if (correlationContainer != null && correlationContainer.eIsProxy()) {
			CorrelationContainer oldCorrelationContainer = correlationContainer;
			correlationContainer = (CorrelationContainer)eResolveProxy((InternalEObject)correlationContainer);
			if (correlationContainer != oldCorrelationContainer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER, oldCorrelationContainer, correlationContainer));
			}
		}
		return correlationContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationContainer basicGetCorrelationContainer() {
		return correlationContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationContainer(CorrelationContainer newCorrelationContainer, NotificationChain msgs) {
		CorrelationContainer oldCorrelationContainer = correlationContainer;
		correlationContainer = newCorrelationContainer;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER, oldCorrelationContainer, newCorrelationContainer);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCorrelationContainer(CorrelationContainer newCorrelationContainer) {
		if (newCorrelationContainer != correlationContainer) {
			NotificationChain msgs = null;
			if (correlationContainer != null)
				msgs = ((InternalEObject)correlationContainer).eInverseRemove(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATION_CONTAINER_PROXY, CorrelationContainer.class, msgs);
			if (newCorrelationContainer != null)
				msgs = ((InternalEObject)newCorrelationContainer).eInverseAdd(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATION_CONTAINER_PROXY, CorrelationContainer.class, msgs);
			msgs = basicSetCorrelationContainer(newCorrelationContainer, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER, newCorrelationContainer, newCorrelationContainer));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getCorrelatedAgents() {
		if (correlatedAgents == null) {
			correlatedAgents = new EObjectResolvingEList(TRCAgentProxy.class, this, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS);
		}
		return correlatedAgents;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationEngine getCorrelationEngine() {
		return correlationEngine;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCorrelationEngine(CorrelationEngine newCorrelationEngine, NotificationChain msgs) {
		CorrelationEngine oldCorrelationEngine = correlationEngine;
		correlationEngine = newCorrelationEngine;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE, oldCorrelationEngine, newCorrelationEngine);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setCorrelationEngine(CorrelationEngine newCorrelationEngine) {
		if (newCorrelationEngine != correlationEngine) {
			NotificationChain msgs = null;
			if (correlationEngine != null)
				msgs = ((InternalEObject)correlationEngine).eInverseRemove(this, HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY, CorrelationEngine.class, msgs);
			if (newCorrelationEngine != null)
				msgs = ((InternalEObject)newCorrelationEngine).eInverseAdd(this, HierarchyPackage.CORRELATION_ENGINE__CORRELATION_CONTAINER_PROXY, CorrelationEngine.class, msgs);
			msgs = basicSetCorrelationEngine(newCorrelationEngine, msgs);
			if (msgs != null) msgs.dispatch();
			if((name == null || name==LoadersUtils.InternalCorrelationName) && newCorrelationEngine!=null && newCorrelationEngine.getName()!=null)
			{
				setName(LoadersUtils.getInternalCorrelationName(newCorrelationEngine.getName()));
			}
			
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE, newCorrelationEngine, newCorrelationEngine));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMonitor getMonitor() {
		if (eContainerFeatureID != HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR) return null;
		return (TRCMonitor)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMonitor(TRCMonitor newMonitor) {
		if (newMonitor != eContainer || (eContainerFeatureID != HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR && newMonitor != null)) {
			if (EcoreUtil.isAncestor(this, newMonitor))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newMonitor != null)
				msgs = ((InternalEObject)newMonitor).eInverseAdd(this, HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES, TRCMonitor.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newMonitor, HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR, newMonitor, newMonitor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
					if (correlationContainer != null)
						msgs = ((InternalEObject)correlationContainer).eInverseRemove(this, HierarchyPackage.CORRELATION_CONTAINER__CORRELATION_CONTAINER_PROXY, CorrelationContainer.class, msgs);
					return basicSetCorrelationContainer((CorrelationContainer)otherEnd, msgs);
				case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
					if (correlationEngine != null)
						msgs = ((InternalEObject)correlationEngine).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE, null, msgs);
					return basicSetCorrelationEngine((CorrelationEngine)otherEnd, msgs);
				case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
					return basicSetCorrelationContainer(null, msgs);
				case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
					return basicSetCorrelationEngine(null, msgs);
				case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
					return eBasicSetContainer(null, HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
					return ((InternalEObject)eContainer).eInverseRemove(this, HierarchyPackage.TRC_MONITOR__CORRELATION_CONTAINER_PROXIES, TRCMonitor.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				return getName();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				return new Long(getCreationTime());
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				if (resolve) return getCorrelationContainer();
				return basicGetCorrelationContainer();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				return getCorrelatedAgents();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				return getCorrelationEngine();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				return getMonitor();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				setCreationTime(((Long)newValue).longValue());
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				setCorrelationContainer((CorrelationContainer)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				getCorrelatedAgents().clear();
				getCorrelatedAgents().addAll((Collection)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				setCorrelationEngine((CorrelationEngine)newValue);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				setMonitor((TRCMonitor)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				setCreationTime(CREATION_TIME_EDEFAULT);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				setCorrelationContainer((CorrelationContainer)null);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				getCorrelatedAgents().clear();
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				setCorrelationEngine((CorrelationEngine)null);
				return;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				setMonitor((TRCMonitor)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CREATION_TIME:
				return creationTime != CREATION_TIME_EDEFAULT;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_CONTAINER:
				return correlationContainer != null;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATED_AGENTS:
				return correlatedAgents != null && !correlatedAgents.isEmpty();
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__CORRELATION_ENGINE:
				return correlationEngine != null;
			case HierarchyPackage.CORRELATION_CONTAINER_PROXY__MONITOR:
				return getMonitor() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", creationTime: ");
		result.append(creationTime);
		result.append(')');
		return result.toString();
	}

} //CorrelationContainerProxyImpl
