/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
    SCAPA Technologies - initial implementation
**********************************************************************/


package org.eclipse.hyades.execution.core;


/**
 * This interface is a placeholder contract between the IExecutor and any
 * class that uses it.  Any class that uses an IExecutor to execute something
 * must pass an object implementing the IExecutableObject interface to the
 * IExecutor.setExecutableObject method.  As commonality among different types
 * of executable objects is discovered, this interface will be refactored to
 * represent that commonality.
 * @version 0.0.2
 */
public interface IExecutableObject {
	
	/**
	 * 
	 * @return
	 */
	public void init();
	
	/**
	 * @return the name of the IExecutableObject. 
	 */
	public String getName();
	
	/**
	 * 
	 * @param executor
	 */
	public void setExecutor(IExecutor executor);
	
	/**
	 * 
	 * @return
	 */
	public IExecutor getExecutor(); 
	
}
