/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

import java.io.Serializable;

/**
 * This type serves as a remote object reference. When remote objects are passed
 * as method arguments, they are passed by reference. Custom input and output
 * serialization streams make use of insances of this type.
 */
public class RemoteObjectReference implements Serializable {
	
	private Integer uniqueId;
	
	/**
	 * Create a reference to the remote object associated with
	 * <code>uniqueId</code>
	 * 
	 * @param uniqueId
	 */
	public RemoteObjectReference(Integer uniqueId) {
		this.uniqueId = uniqueId;
	}
	
	/**
	 * Get the object referred to by this reference.
	 * 
	 * @return
	 */
	public Object getReferencedObject() {
		Object refObj = Marshaller.getInstanceFromMap(uniqueId);
		if ( refObj == null )
			throw new IllegalStateException("The referenced remote object could not be found");
		return refObj;
	}

}
