/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Rational - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.invocation;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

/**
 * This stream type is used to unmarshal remotely invoked method calls.
 * Remote objects are passed by reference. This stream resolves remote object
 * references to the appropriate objects.
 */
public class RemoteReferenceInputStream extends ObjectInputStream {

	/**
	 * @param in
	 * @throws java.io.IOException
	 */
	public RemoteReferenceInputStream(InputStream in) throws IOException {
		super(in);
		init();
	}

	/**
	 * @throws java.io.IOException
	 * @throws java.lang.SecurityException
	 */
	public RemoteReferenceInputStream() throws IOException, SecurityException {
		super();
		init();
	}
	
	private void init() throws SecurityException {
		enableResolveObject(true);
	}

	/**
	 * When <code>RemoteObjectReference</code> objects are encountered, this
	 * method resolves the references to their referred to instances.
	 * 
	 * @see java.io.ObjectInputStream#resolveObject(java.lang.Object)
	 */
	protected Object resolveObject(Object obj) throws IOException {
		if ( !(obj instanceof RemoteObjectReference) )
			return super.resolveObject(obj);
		return ((RemoteObjectReference)obj).getReferencedObject();
	}

}
