/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;


import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser;

public class DeadLockDetect {
	
	
	public DeadLockDetect(DumpData dd)
	{
		// only set pointers in this method
		// use collectData() for other processing
		_dumpData = dd;
		_monitors = dd.getMonitors();
		_threads = dd.getThreads();
		_threadDump = dd.getThreadDump();
		_threadDumpLines = _dumpData.getThreadDump().getThreadDumpVector();
		_idents = null;
		_ownedMonitors = null;
		_sysMon = null;
		theGraph = new DirectedGraph(_threads);
	}
	
	public DeadLockDetect(DumpData dd, String _logLevel) {
		this(dd);
		if( _logLevel.equalsIgnoreCase("DEBUG") ) {
			setLogLevel(DumpParser.DEBUG);
		}
		else {
			setLogLevel(DumpParser.DETAIL);
		}
	}
	
	protected void collectData() 
	{

		// Each section below comes before one-another, so this should be consistent from platform
		// to platform and from jdk version to jdk version.  when this changes, it will fail.
		// Otherwise use the startPosition of getLocation to be 0 and it will never fail
//		int monIndex = getLocation(_threadDumpLines,0, "Monitor Pool Dump (flat & inflated object-monitors):");

		int monIndex = getLocation(_threadDumpLines,0, "Monitor Pool Dump (");
		logDebug("MonitorPoolDump@"+monIndex);
		int sysMonIndex = getLocation(_threadDumpLines,monIndex,"JVM System Monitor Dump (registered monitors):");
		logDebug("JVMSysMon@"+sysMonIndex);
		int identIndex = getLocation(_threadDumpLines,sysMonIndex,"Thread identifiers (as used in flat monitors):");
		logDebug("identIndex@"+identIndex);
		// Parse the idents portion of the javacore
		logDebug("Populating Idents");
		ParseIdents pi = new ParseIdents(_threadDump, _threads);
		pi.populate(identIndex);
		_idents = pi.getIdents();
		logDebug("idents Populated");
		
		// Parse the Threads portion of the javacore
		logDebug("Populating TID");
		ParseTID ptid = new ParseTID(_threadDumpLines);
		ptid.doIt();	
		_tid = ptid.getTIDMap();
		theGraph.putReversedTid(ptid.getReversedTIDMap());
		logDebug("TID populated");
		
		// Parse the Monitors of the javacore
		logDebug("Populating Monitor Owner");
		ParseMonitorOwner pmo = new ParseMonitorOwner(_idents,_threads,_monitors, _tid,  _threadDump);
		pmo.doIt(monIndex);
		logDebug("Monitor owner populated");
		
		// Parse the System Monitors of the javacore
		logDebug("Populating system monitors");
		ParseSystemMonitor psm = new ParseSystemMonitor(_threads,_idents, _threadDumpLines);
			// Think about not providing an endIndex such as identIndex
		psm.doIt(sysMonIndex,identIndex);		
		logDebug("system monitors populated");
		_ownedMonitors = pmo.getOwnedMonitors();
		_sysMon = psm.getSysMon();
		
		logDebug("building directed graph for deadlock detection");
		buildDirectedGraph();
		logDebug("directed graph built");

	}
	
	protected void buildDirectedGraph()
	{

		// start building graph by inserting all vertex, in this case al threads from _threads
		Iterator i = _threads.keySet().iterator();
		while(i.hasNext())
		{
			theGraph.addVertex(_threads.get(i.next()));
		}
		
		
/*		Object[] o = theGraph.getObjectList();
		for(int g=0;g<o.length;g++)
		{
			System.out.println("?? " + ((Thd)o[g])._threadId);
		}
		*/

		// Once we insert all vertex, now we can start adding Monitors with Thread direction
		// Direction is a Monitor which has Owner -> Waiter
		// i.e. addEdge(monitor, ownerThd, waitingThd)
		i = _ownedMonitors.keySet().iterator();
		Monitor m = null;
		while(i.hasNext())
		{
			m = (Monitor)_ownedMonitors.get(i.next());
			for(int k=0; k<m._waiters.size(); k++)
				theGraph.addEdge(m,m._owner, m._waiters.get(k));
		}
		
		// Once we insert all ownedMonitors, we insert all owned System Monitors too
		// this is done via the same fashion as the previous insertion was done
		i = _sysMon.keySet().iterator();
		while(i.hasNext())
		{
			m = (Monitor)_sysMon.get(i.next());
			for(int k=0; k<m._waiters.size(); k++)
				theGraph.addEdge(m,m._owner, m._waiters.get(k));
		}		
		
	}
	
	public void doIt()
	{

		collectData();
		theGraph.findCircularPattern();
		logDebug("finding/looking for circular pattern");
		// order for below methods is critical.  getnotnullpairs() must be called before getdeadlockexists()
		deadlockResult = theGraph.getNotNullPairs();
		doesDeadlockExist = theGraph.getDeadlockExists();
	}
	
	
	/*
	 * This method should only be called once
	 * If there is a need to call getResults() more than once then provide
	 * programmatic caching scheme if you cannot use the DumpData caching scheme
	 * 
	 */
	public Vector getResults() 
	{
		return deadlockResult;
	}	
	
	public void copyIt(String from, String to) {

		Vector _lines = _threadDump.getThreadDumpVector();
		deadlockResult = new Vector(100);
		
		String line = null;
		for(int i=0; i<_lines.size();i++) {
			line = (String)_lines.get(i);
			if( line.indexOf(from) != -1 ) {
				doesDeadlockExist = true;
				for( int j=i; j<_lines.size(); j++) {
						line = (String)_lines.get(j); // capture the line
						line = line.substring(line.indexOf(":")+1,line.length()); // remove the extra TA line numbers.

						if( line.indexOf(to) != -1 ) {
							
							break; // text captured, leave inner loop
						}
						deadlockResult.add(line);
				}
				break; // text captured, leave outter loop
				
			}
			
		}
      if ( doesDeadlockExist == false )	
          deadlockResult = null;
		
	}

	public final static int getLocation(Vector vector, int startIndex,String lookForData) 
	{

		int index = 0;
		int size = vector.size();
		for(index = startIndex; index < size; index++)
		{
			if(((String)vector.elementAt(index)).indexOf(lookForData) >= 0)
			{
				break;
			}
				
		}
		return index;		
	}		
	public boolean getDeadlockExists() 
	{
		return doesDeadlockExist;
	}
	
	private DirectedGraph theGraph 		= null;
	private Hashtable _threads 			= null;
	private Hashtable _ownedMonitors 		= null;
	private Hashtable _sysMon 				= null;
	private Hashtable _tid					= null;
	private Hashtable _monitors 			= null;
	private Hashtable _idents 				= null;
	private ThreadDump _threadDump			= null;
	private Vector _threadDumpLines 		= null;
	/* 
	 * use the pointer to DumpData in order to provide information such as threads, monitors
	 * and the thread dump to the rest of the code
	 */
	private DumpData _dumpData				= null;
	private boolean doesDeadlockExist		= false;
	private Vector deadlockResult 			= null;
	private int _logLevel 					= -1;
	
	public void setLogLevel( int logLevel )
	{
			_logLevel = logLevel;
	}
	
	public void logDebug( String msg )
	{

			if ( _logLevel >= DumpParser.DEBUG )
					System.err.println( "DEBUG: " + msg );
	}
	
}
