/**********************************************************************
Copyright (c) 2004 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
/*
 * DumpParser - IBM, March 2001
 */

package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import java.io.IOException;
import java.util.StringTokenizer;

import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.TaException;
import org.eclipse.hyades.collection.threadanalyzer.Thd;


public class DumpParserSolaris extends DumpParser
{

   public DumpParserSolaris( )
   {
   }

   public void parse( DumpData d ) throws Exception
   {
       //System.out.println( "parse" );
       try
       {
          if( _r.ready() )
          {
             String s = _r.readLine(); // version
             getThreadData( d );

          }
       }
       catch( Exception e )
       {
		  logErr( TAUtils.getNLSValue("ta.errmsg.ExceptionWhileParsing", "exception while parsing line") + ": " + _lineNo + " -- " + _dumpInName );
          throw new TaException(""+_lineNo, e);
       }
       
   }


   private void getThreadData( DumpData d ) throws Exception
   {
      readToDump();
      String line = null;
      char firstChar = 0;
      line = getLine( d );
      Thd thd = null;
      while( line.length() > 0 )
      {
         firstChar = line.charAt( 0 );
         if( firstChar == '\"' ) // new thread
         {
            int idx1 = line.indexOf( '\"' );
            int idx2 = line.indexOf( '\"', idx1+1 );
            String thdNm = line.substring( idx1+1, idx2 );
            idx1 = line.indexOf( "sys_thread_t:" );
            String line2 = line.substring( idx1 );
            idx2 = line2.indexOf( ',' );
            String threadId = line2.substring( 13, idx2 );
            idx1 = line.indexOf( "state:" )+6; 
            idx2 = line.indexOf( ',', idx1 );
            String state = line.substring( idx1, idx2 );
            idx1 = line.indexOf( "prio=" );
            String priority = line.substring( idx1+5 );
       //     System.out.println( thdNm + " - " + threadId + " - " + state + " - " + priority );
            thd = d.addThd( thdNm, threadId, state, priority );
            line = getLine( d );   // ccc
         }
         else if( firstChar == '[' )  // thread stack entry // ccc if part
         {
             if (line.charAt(0) != '-') // ccc this if statement
             {
             
             
            //String line2 = line.substring( 4 );
            
            // ccc above line originally there     
            StringTokenizer st = new StringTokenizer(line);
            String line2 = new String(st.nextToken());
            line2 = st.nextToken();
            if (st.hasMoreTokens())
            {
                line2 = line2 + " " + st.nextToken();
            }
                                              






            boolean isNative = false;
            String moduleName = null;
            String lineno = null;
            int idx1 = line2.indexOf( "(Native Method)" );
            if ( idx1 > 0 )
            {
               isNative = true;

               line2 = line2.substring( 0, idx1 );
            }
            else
            {
               idx1 = line2.indexOf( "(" );
               ++idx1;
               String moduleInfo = line2.substring( idx1 );
               line2 = line2.substring( 0, idx1-1 );
               
               int idx2 = moduleInfo.indexOf( ':' );
               if( idx2 > 0 )
               {
                  lineno = moduleInfo.substring( idx2+1, moduleInfo.indexOf( ')', idx2) ); //originally was idx2-1
                  moduleName = moduleInfo.substring( 0, idx2 ); 
               }
               else
               {
                  idx2 = moduleInfo.indexOf( ')' ); //originally '(' instead of ')'
                  moduleName = moduleInfo.substring( 0, idx2 );
               }
            }
            String method = line2.substring( line2.lastIndexOf( '.' ) + 1 );
            String pkg = line2.substring( 0, line2.lastIndexOf( '.' ) );
            int iLineNo = -1;
            if (lineno != null) 
            {
               iLineNo = Integer.parseInt( lineno );
            }
            StkEntry se = new StkEntry( method, pkg, moduleName, iLineNo, isNative );
      //      System.out.println( "  -- " + pkg + " . " + method + " - "  +  " - " + moduleName + " - " + lineno + " - " + isNative );
            thd.addStackEntry( se );
         }

         }

         line = getLine( d );
      }
   }

   private void readToDump()
   {
      /* d111401 - removed dependency on jakarta re
       RE ftdRE = null;
      try
      {

         ftdRE = new RE( "Full thread dump.*$" ); 
      }
      catch( Exception e )
      {
         logErr( "internal error: RE(1)" );
         System.exit( -1 );
      }
      */
      int lineNo = 0;
      int matchAt = -1;
      try
      {

         while( _r.ready() )
         {
            String str1 = _r.readLine();
            ++lineNo;
            /* d111401
            if( ftdRE.match( str1 ) )
            */
            if( str1.indexOf( "Full thread dump" ) > -1 )
            {
               matchAt = lineNo;
               break;
            }
         }
      }
      catch( IOException ioe )
      {
         logErr( TAUtils.getNLSValue("ta.errmsg.ErrorReading", "error reading") + " " + "stderr");
         System.exit( -1 );
      }

   }


}


